/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.common.Weight;
import io.helidon.scheduling.Task;
import io.helidon.scheduling.TaskManager;
import io.helidon.service.registry.Service;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Weight(value=90.0)
@Service.Singleton
class TaskManagerImpl
implements TaskManager {
    private final Map<String, Task> tasks = new ConcurrentHashMap<String, Task>();

    TaskManagerImpl() {
    }

    @Override
    public void shutdown() {
        List<Task> allTasks = List.copyOf(this.tasks.values());
        for (Task task : allTasks) {
            task.close();
            this.tasks.remove(task.id());
        }
    }

    @Override
    public void register(Task task) {
        this.tasks.put(task.id(), task);
    }

    @Override
    public boolean remove(Task task) {
        Task existing = this.tasks.remove(task.id());
        return existing != null;
    }

    @Override
    public Collection<Task> tasks() {
        return List.copyOf(this.tasks.values());
    }
}

