/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.scheduling.TaskConfigBlueprint;
import io.helidon.scheduling.TaskConfigDecorator;
import io.helidon.scheduling.TaskManager;
import io.helidon.service.registry.RegistryBuilderSupport;
import io.helidon.service.registry.ServiceRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.scheduling.TaskConfigBlueprint")
public interface TaskConfig
extends TaskConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskConfig instance) {
        return (Builder)TaskConfig.builder().from(instance);
    }

    public static TaskConfig create(Config config) {
        return ((Builder)TaskConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static TaskConfig create(io.helidon.common.config.Config config) {
        return TaskConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static TaskConfig create() {
        return TaskConfig.builder().buildPrototype();
    }

    @Override
    public ScheduledExecutorService executor();

    @Override
    public TaskManager taskManager();

    @Override
    public Optional<String> id();

    public static class Builder
    extends BuilderBase<Builder, TaskConfig>
    implements io.helidon.common.Builder<Builder, TaskConfig> {
        private Builder() {
        }

        public TaskConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TaskConfigImpl(this);
        }

        public TaskConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TaskConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean taskManagerDiscoverServices = true;
        private Config config;
        private ScheduledExecutorService executor;
        private ServiceRegistry serviceRegistry;
        private String id;
        private TaskManager taskManager;

        protected BuilderBase() {
        }

        public BUILDER from(TaskConfig prototype) {
            this.executor(prototype.executor());
            this.taskManager(prototype.taskManager());
            this.taskManagerDiscoverServices = false;
            this.id(prototype.id());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.executor().ifPresent(this::executor);
            builder.taskManager().ifPresent(this::taskManager);
            this.taskManagerDiscoverServices = builder.taskManagerDiscoverServices;
            builder.id().ifPresent(this::id);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("id").as(String.class).ifPresent(this::id);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceRegistry(ServiceRegistry registry) {
            Objects.requireNonNull(registry);
            this.serviceRegistry = registry;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ScheduledExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER taskManager(TaskManager taskManager) {
            Objects.requireNonNull(taskManager);
            this.taskManager = taskManager;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearId() {
            this.id = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER id(String id) {
            Objects.requireNonNull(id);
            this.id = id;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ScheduledExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public Optional<TaskManager> taskManager() {
            return Optional.ofNullable(this.taskManager);
        }

        public Optional<String> id() {
            return Optional.ofNullable(this.id);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "TaskConfigBuilder{executor=" + String.valueOf(this.executor) + ",taskManager=" + String.valueOf(this.taskManager) + ",id=" + this.id + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            Optional<ServiceRegistry> registry = Optional.ofNullable(this.serviceRegistry);
            Optional taskManagerQualifier = Optional.empty();
            RegistryBuilderSupport.service(registry, (TypeName)TypeName.create((String)"io.helidon.scheduling.TaskManager"), Optional.ofNullable(this.taskManager), (boolean)this.taskManagerDiscoverServices, taskManagerQualifier).ifPresent(this::taskManager);
            new TaskConfigDecorator<BuilderBase>().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.executor == null) {
                collector.fatal(this.getClass(), "Property \"executor\" must not be null, but not set");
            }
            if (this.taskManager == null) {
                collector.fatal(this.getClass(), "Property \"taskManager\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER id(Optional<String> id) {
            Objects.requireNonNull(id);
            this.id = id.map(String.class::cast).orElse(this.id);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TaskConfigImpl
        implements TaskConfig {
            private final Optional<String> id;
            private final ScheduledExecutorService executor;
            private final TaskManager taskManager;

            protected TaskConfigImpl(BuilderBase<?, ?> builder) {
                this.executor = builder.executor().get();
                this.taskManager = builder.taskManager().get();
                this.id = builder.id().map(Function.identity());
            }

            @Override
            public ScheduledExecutorService executor() {
                return this.executor;
            }

            @Override
            public TaskManager taskManager() {
                return this.taskManager;
            }

            @Override
            public Optional<String> id() {
                return this.id;
            }

            public String toString() {
                return "TaskConfig{executor=" + String.valueOf(this.executor) + ",taskManager=" + String.valueOf(this.taskManager) + ",id=" + String.valueOf(this.id) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaskConfig)) {
                    return false;
                }
                TaskConfig other = (TaskConfig)o;
                return Objects.equals(this.executor, other.executor()) && Objects.equals(this.taskManager, other.taskManager()) && Objects.equals(this.id, other.id());
            }

            public int hashCode() {
                return Objects.hash(this.executor, this.taskManager, this.id);
            }
        }
    }
}

