/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.common.Builder;
import io.helidon.common.LazyValue;
import io.helidon.common.configurable.ScheduledThreadPoolConfig;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.scheduling.CronConfig;
import io.helidon.scheduling.CronInvocation;
import io.helidon.scheduling.FixedRate;
import io.helidon.scheduling.FixedRateConfig;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.SchedulingException;
import io.helidon.scheduling.Task;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class Scheduling {
    static final String DEFAULT_THREAD_NAME_PREFIX = "scheduled-";
    static final LazyValue<ScheduledExecutorService> DEFAULT_SCHEDULER = LazyValue.create(() -> ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix(DEFAULT_THREAD_NAME_PREFIX)).build().get());

    private Scheduling() {
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static FixedRateBuilder fixedRateBuilder() {
        return new FixedRateBuilder();
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static FixedRateConfig.Builder fixedRate() {
        return io.helidon.scheduling.FixedRate.builder();
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static CronBuilder cronBuilder() {
        return new CronBuilder();
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static CronConfig.Builder cron() {
        return io.helidon.scheduling.Cron.builder();
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static final class FixedRateBuilder
    implements Builder<FixedRateBuilder, Task> {
        private ScheduledExecutorService executorService;
        private long initialDelay = 0L;
        private Long delay;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private ScheduledConsumer<FixedRateInvocation> task;

        private FixedRateBuilder() {
        }

        public FixedRateBuilder executor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public FixedRateBuilder initialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public FixedRateBuilder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public FixedRateBuilder task(ScheduledConsumer<FixedRateInvocation> task) {
            this.task = task;
            return this;
        }

        public FixedRateBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Task build() {
            if (this.task == null) {
                throw new SchedulingException("No task to execute provided!");
            }
            if (this.delay == null) {
                throw new SchedulingException("No delay provided!");
            }
            if (this.executorService == null) {
                this.executorService = ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix(Scheduling.DEFAULT_THREAD_NAME_PREFIX)).build().get();
            }
            ChronoUnit chronoUnit = this.timeUnit.toChronoUnit();
            return ((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)io.helidon.scheduling.FixedRate.builder().executor(this.executorService)).delayBy(Duration.of(this.initialDelay, chronoUnit))).interval(Duration.of(this.delay, chronoUnit))).delayType(FixedRate.DelayType.SINCE_PREVIOUS_START)).task(this.task)).build();
        }
    }

    @Deprecated(since="4.0.2", forRemoval=true)
    public static final class CronBuilder
    implements Builder<CronBuilder, Task> {
        private ScheduledExecutorService executorService;
        private String cronExpression;
        private boolean concurrentExecution = true;
        private ScheduledConsumer<CronInvocation> task;

        private CronBuilder() {
        }

        public CronBuilder executor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public CronBuilder expression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public CronBuilder concurrentExecution(boolean allowConcurrentExecution) {
            this.concurrentExecution = allowConcurrentExecution;
            return this;
        }

        public CronBuilder task(ScheduledConsumer<CronInvocation> task) {
            this.task = task;
            return this;
        }

        public Task build() {
            if (this.task == null) {
                throw new SchedulingException("No task to execute provided!");
            }
            if (this.cronExpression == null) {
                throw new SchedulingException("No CRON expression provided!");
            }
            if (this.executorService == null) {
                this.executorService = ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix(Scheduling.DEFAULT_THREAD_NAME_PREFIX)).build().get();
            }
            return ((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)io.helidon.scheduling.Cron.builder().executor(this.executorService)).expression(this.cronExpression)).concurrentExecution(this.concurrentExecution)).task(this.task)).build();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Target(value={ElementType.METHOD})
    public static @interface Cron {
        public String value();

        public boolean concurrent() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Target(value={ElementType.METHOD})
    public static @interface FixedRate {
        public String value();

        public String delayBy() default "PT0S";

        public FixedRate.DelayType delayType() default FixedRate.DelayType.SINCE_PREVIOUS_START;
    }
}

