/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.scheduling.FixedRate;
import io.helidon.scheduling.FixedRateConfig;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class FixedRateTask
implements FixedRate {
    private static final System.Logger LOGGER = System.getLogger(FixedRateTask.class.getName());
    private final AtomicLong iteration = new AtomicLong(0L);
    private final ScheduledExecutorService executorService;
    private final Duration initialDelay;
    private final Duration interval;
    private final ScheduledConsumer<FixedRateInvocation> actualTask;
    private final ScheduledFuture<?> future;
    private final FixedRateConfig config;
    private final String taskId;

    FixedRateTask(FixedRateConfig config) {
        this.config = config;
        this.initialDelay = config.delayBy();
        this.interval = config.interval();
        this.actualTask = config.task();
        this.executorService = config.executor();
        this.taskId = config.id().orElseGet(() -> UUID.randomUUID().toString());
        this.future = switch (config.delayType()) {
            default -> throw new MatchException(null, null);
            case FixedRate.DelayType.SINCE_PREVIOUS_START -> this.executorService.scheduleAtFixedRate(this::run, this.initialDelay.toMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS);
            case FixedRate.DelayType.SINCE_PREVIOUS_END -> this.executorService.scheduleWithFixedDelay(this::run, this.initialDelay.toMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS);
        };
        config.taskManager().register(this);
    }

    public FixedRateConfig prototype() {
        return this.config;
    }

    @Override
    public String description() {
        if (this.initialDelay.isZero()) {
            return String.format("every %s", this.interval);
        }
        return String.format("every %s with initial delay of %s ", this.interval, this.initialDelay);
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.executorService;
    }

    @Override
    public void close() {
        this.future.cancel(false);
        this.config.taskManager().remove(this);
    }

    @Override
    public String id() {
        return this.taskId;
    }

    public String toString() {
        return this.description() + "(" + this.taskId + ")";
    }

    void run() {
        try {
            final long it = this.iteration.incrementAndGet();
            this.actualTask.run(new FixedRateInvocation(){

                @Override
                public Duration delayBy() {
                    return FixedRateTask.this.initialDelay;
                }

                @Override
                public Duration interval() {
                    return FixedRateTask.this.interval;
                }

                @Override
                public long initialDelay() {
                    return FixedRateTask.this.initialDelay.toMillis();
                }

                @Override
                public long delay() {
                    return FixedRateTask.this.interval.toMillis();
                }

                @Override
                public TimeUnit timeUnit() {
                    return TimeUnit.MILLISECONDS;
                }

                @Override
                public long iteration() {
                    return it;
                }

                @Override
                public String description() {
                    return FixedRateTask.this.description();
                }
            });
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, () -> "Error when invoking scheduled method.", e);
        }
    }
}

