/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.scheduling.FixedRateConfig;
import io.helidon.scheduling.TaskConfigDecorator;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

final class FixedRateDecorator
extends TaskConfigDecorator<FixedRateConfig.BuilderBase<?, ?>> {
    FixedRateDecorator() {
    }

    @Override
    public void decorate(FixedRateConfig.BuilderBase<?, ?> target) {
        super.decorate(target);
        target.initialDelay(target.delayBy().toMillis());
        target.interval().map(Duration::toMillis).ifPresent(target::delay);
        target.timeUnit(TimeUnit.MILLISECONDS);
    }

    static final class TimeUnitDecorator
    implements Prototype.OptionDecorator<FixedRateConfig.BuilderBase<?, ?>, TimeUnit> {
        TimeUnitDecorator() {
        }

        public void decorate(FixedRateConfig.BuilderBase<?, ?> builder, TimeUnit optionValue) {
            builder.delay().ifPresent(it -> builder.interval(Duration.of(it, optionValue.toChronoUnit())));
            builder.initialDelay().ifPresent(it -> builder.delayBy(Duration.of(it, optionValue.toChronoUnit())));
        }
    }

    static final class DelayDecorator
    implements Prototype.OptionDecorator<FixedRateConfig.BuilderBase<?, ?>, Long> {
        DelayDecorator() {
        }

        public void decorate(FixedRateConfig.BuilderBase<?, ?> builder, Long optionValue) {
            builder.interval(Duration.of(optionValue, builder.timeUnit().toChronoUnit()));
        }
    }

    static final class InitialDelayDecorator
    implements Prototype.OptionDecorator<FixedRateConfig.BuilderBase<?, ?>, Long> {
        InitialDelayDecorator() {
        }

        public void decorate(FixedRateConfig.BuilderBase<?, ?> builder, Long optionValue) {
            builder.delayBy(Duration.of(optionValue, builder.timeUnit().toChronoUnit()));
        }
    }
}

