/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.scheduling.FixedRate;
import io.helidon.scheduling.FixedRateConfigBlueprint;
import io.helidon.scheduling.FixedRateDecorator;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.TaskConfig;
import io.helidon.service.registry.ServiceRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.scheduling.FixedRateConfigBlueprint")
public interface FixedRateConfig
extends FixedRateConfigBlueprint,
Prototype.Api,
TaskConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FixedRateConfig instance) {
        return (Builder)FixedRateConfig.builder().from(instance);
    }

    public static FixedRateConfig create(Config config) {
        return ((Builder)FixedRateConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static FixedRateConfig create(io.helidon.common.config.Config config) {
        return FixedRateConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    public long initialDelay();

    @Override
    public long delay();

    @Override
    public TimeUnit timeUnit();

    @Override
    public Duration delayBy();

    @Override
    public Duration interval();

    @Override
    public FixedRate.DelayType delayType();

    @Override
    public ScheduledConsumer<FixedRateInvocation> task();

    public static class Builder
    extends BuilderBase<Builder, FixedRateConfig>
    implements io.helidon.common.Builder<Builder, FixedRate> {
        private Builder() {
        }

        public FixedRateConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FixedRateConfigImpl(this);
        }

        public FixedRate build() {
            return FixedRate.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FixedRateConfig>
    extends TaskConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private FixedRate.DelayType delayType = FixedRate.DelayType.SINCE_PREVIOUS_START;
        private Duration delayBy = Duration.parse("PT0S");
        private Duration interval;
        private Long delay;
        private Long initialDelay;
        private ScheduledConsumer<FixedRateInvocation> task;
        private ServiceRegistry serviceRegistry;
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        protected BuilderBase() {
        }

        public BUILDER from(FixedRateConfig prototype) {
            super.from(prototype);
            this.initialDelay(prototype.initialDelay());
            this.delay(prototype.delay());
            this.timeUnit(prototype.timeUnit());
            this.delayBy(prototype.delayBy());
            this.interval(prototype.interval());
            this.delayType(prototype.delayType());
            this.task(prototype.task());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.initialDelay().ifPresent(this::initialDelay);
            builder.delay().ifPresent(this::delay);
            this.timeUnit(builder.timeUnit());
            this.delayBy(builder.delayBy());
            builder.interval().ifPresent(this::interval);
            this.delayType(builder.delayType());
            builder.task().ifPresent(this::task);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("initial-delay").as(Long.class).ifPresent(this::initialDelay);
            config.get("delay").as(Long.class).ifPresent(this::delay);
            config.get("time-unit").as(TimeUnit.class).ifPresent(this::timeUnit);
            config.get("delay-by").as(Duration.class).ifPresent(this::delayBy);
            config.get("interval").as(Duration.class).ifPresent(this::interval);
            config.get("delay-type").as(FixedRate.DelayType.class).ifPresent(this::delayType);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER serviceRegistry(ServiceRegistry registry) {
            Objects.requireNonNull(registry);
            this.serviceRegistry = registry;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public BUILDER initialDelay(long initialDelay) {
            new FixedRateDecorator.InitialDelayDecorator().decorate(this, initialDelay);
            this.initialDelay = initialDelay;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public BUILDER delay(long delay) {
            new FixedRateDecorator.DelayDecorator().decorate(this, delay);
            this.delay = delay;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public BUILDER timeUnit(TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            new FixedRateDecorator.TimeUnitDecorator().decorate(this, timeUnit);
            this.timeUnit = timeUnit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delayBy(Duration delayBy) {
            Objects.requireNonNull(delayBy);
            this.delayBy = delayBy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interval(Duration interval) {
            Objects.requireNonNull(interval);
            this.interval = interval;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delayType(FixedRate.DelayType delayType) {
            Objects.requireNonNull(delayType);
            this.delayType = delayType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER task(ScheduledConsumer<FixedRateInvocation> task) {
            Objects.requireNonNull(task);
            this.task = task;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public Optional<Long> initialDelay() {
            return Optional.ofNullable(this.initialDelay);
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public Optional<Long> delay() {
            return Optional.ofNullable(this.delay);
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public TimeUnit timeUnit() {
            return this.timeUnit;
        }

        public Duration delayBy() {
            return this.delayBy;
        }

        public Optional<Duration> interval() {
            return Optional.ofNullable(this.interval);
        }

        public FixedRate.DelayType delayType() {
            return this.delayType;
        }

        public Optional<ScheduledConsumer<FixedRateInvocation>> task() {
            return Optional.ofNullable(this.task);
        }

        @Override
        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "FixedRateConfigBuilder{initialDelay=" + this.initialDelay + ",delay=" + this.delay + ",timeUnit=" + String.valueOf((Object)this.timeUnit) + ",delayBy=" + String.valueOf(this.delayBy) + ",interval=" + String.valueOf(this.interval) + ",delayType=" + String.valueOf((Object)this.delayType) + ",task=" + String.valueOf(this.task) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config == null ? Config.empty() : this.config;
            Optional<ServiceRegistry> registry = Optional.ofNullable(this.serviceRegistry);
            new FixedRateDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.initialDelay == null) {
                collector.fatal(this.getClass(), "Property \"initial-delay\" is required, but not set");
            }
            if (this.delay == null) {
                collector.fatal(this.getClass(), "Property \"delay\" is required, but not set");
            }
            if (this.interval == null) {
                collector.fatal(this.getClass(), "Property \"interval\" is required, but not set");
            }
            if (this.task == null) {
                collector.fatal(this.getClass(), "Property \"task\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class FixedRateConfigImpl
        extends TaskConfig.BuilderBase.TaskConfigImpl
        implements FixedRateConfig,
        Supplier<FixedRate> {
            private final FixedRate.DelayType delayType;
            private final Duration delayBy;
            private final Duration interval;
            private final long delay;
            private final long initialDelay;
            private final ScheduledConsumer<FixedRateInvocation> task;
            private final TimeUnit timeUnit;

            protected FixedRateConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.initialDelay = builder.initialDelay().get();
                this.delay = builder.delay().get();
                this.timeUnit = builder.timeUnit();
                this.delayBy = builder.delayBy();
                this.interval = builder.interval().get();
                this.delayType = builder.delayType();
                this.task = builder.task().get();
            }

            public FixedRate build() {
                return FixedRate.create(this);
            }

            @Override
            public FixedRate get() {
                return this.build();
            }

            @Override
            public long initialDelay() {
                return this.initialDelay;
            }

            @Override
            public long delay() {
                return this.delay;
            }

            @Override
            public TimeUnit timeUnit() {
                return this.timeUnit;
            }

            @Override
            public Duration delayBy() {
                return this.delayBy;
            }

            @Override
            public Duration interval() {
                return this.interval;
            }

            @Override
            public FixedRate.DelayType delayType() {
                return this.delayType;
            }

            @Override
            public ScheduledConsumer<FixedRateInvocation> task() {
                return this.task;
            }

            @Override
            public String toString() {
                return "FixedRateConfig{initialDelay=" + this.initialDelay + ",delay=" + this.delay + ",timeUnit=" + String.valueOf((Object)this.timeUnit) + ",delayBy=" + String.valueOf(this.delayBy) + ",interval=" + String.valueOf(this.interval) + ",delayType=" + String.valueOf((Object)this.delayType) + ",task=" + String.valueOf(this.task) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FixedRateConfig)) {
                    return false;
                }
                FixedRateConfig other = (FixedRateConfig)o;
                return super.equals(other) && this.initialDelay == other.initialDelay() && this.delay == other.delay() && Objects.equals((Object)this.timeUnit, (Object)other.timeUnit()) && Objects.equals(this.delayBy, other.delayBy()) && Objects.equals(this.interval, other.interval()) && Objects.equals((Object)this.delayType, (Object)other.delayType()) && Objects.equals(this.task, other.task());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(new Object[]{this.initialDelay, this.delay, this.timeUnit, this.delayBy, this.interval, this.delayType, this.task});
            }
        }
    }
}

