/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.scheduling.Cron;
import io.helidon.scheduling.CronConfigBlueprint;
import io.helidon.scheduling.CronInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.TaskConfig;
import io.helidon.service.registry.ServiceRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.scheduling.CronConfigBlueprint")
public interface CronConfig
extends CronConfigBlueprint,
Prototype.Api,
TaskConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CronConfig instance) {
        return (Builder)CronConfig.builder().from(instance);
    }

    public static CronConfig create(Config config) {
        return ((Builder)CronConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static CronConfig create(io.helidon.common.config.Config config) {
        return CronConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    public String expression();

    @Override
    public boolean concurrentExecution();

    @Override
    public ScheduledConsumer<CronInvocation> task();

    public static class Builder
    extends BuilderBase<Builder, CronConfig>
    implements io.helidon.common.Builder<Builder, Cron> {
        private Builder() {
        }

        public CronConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CronConfigImpl(this);
        }

        public Cron build() {
            return Cron.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CronConfig>
    extends TaskConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean concurrentExecution = true;
        private Config config;
        private ScheduledConsumer<CronInvocation> task;
        private ServiceRegistry serviceRegistry;
        private String expression;

        protected BuilderBase() {
        }

        public BUILDER from(CronConfig prototype) {
            super.from(prototype);
            this.expression(prototype.expression());
            this.concurrentExecution(prototype.concurrentExecution());
            this.task(prototype.task());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.expression().ifPresent(this::expression);
            this.concurrentExecution(builder.concurrentExecution());
            builder.task().ifPresent(this::task);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("expression").as(String.class).ifPresent(this::expression);
            config.get("concurrent").as(Boolean.class).ifPresent(this::concurrentExecution);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER serviceRegistry(ServiceRegistry registry) {
            Objects.requireNonNull(registry);
            this.serviceRegistry = registry;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER expression(String expression) {
            Objects.requireNonNull(expression);
            this.expression = expression;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER concurrentExecution(boolean concurrentExecution) {
            this.concurrentExecution = concurrentExecution;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER task(ScheduledConsumer<CronInvocation> task) {
            Objects.requireNonNull(task);
            this.task = task;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> expression() {
            return Optional.ofNullable(this.expression);
        }

        public boolean concurrentExecution() {
            return this.concurrentExecution;
        }

        public Optional<ScheduledConsumer<CronInvocation>> task() {
            return Optional.ofNullable(this.task);
        }

        @Override
        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "CronConfigBuilder{expression=" + this.expression + ",concurrentExecution=" + this.concurrentExecution + ",task=" + String.valueOf(this.task) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config == null ? Config.empty() : this.config;
            Optional<ServiceRegistry> registry = Optional.ofNullable(this.serviceRegistry);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.expression == null) {
                collector.fatal(this.getClass(), "Property \"expression\" is required, but not set");
            }
            if (this.task == null) {
                collector.fatal(this.getClass(), "Property \"task\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class CronConfigImpl
        extends TaskConfig.BuilderBase.TaskConfigImpl
        implements CronConfig,
        Supplier<Cron> {
            private final boolean concurrentExecution;
            private final ScheduledConsumer<CronInvocation> task;
            private final String expression;

            protected CronConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.expression = builder.expression().get();
                this.concurrentExecution = builder.concurrentExecution();
                this.task = builder.task().get();
            }

            public Cron build() {
                return Cron.create(this);
            }

            @Override
            public Cron get() {
                return this.build();
            }

            @Override
            public String expression() {
                return this.expression;
            }

            @Override
            public boolean concurrentExecution() {
                return this.concurrentExecution;
            }

            @Override
            public ScheduledConsumer<CronInvocation> task() {
                return this.task;
            }

            @Override
            public String toString() {
                return "CronConfig{expression=" + this.expression + ",concurrentExecution=" + this.concurrentExecution + ",task=" + String.valueOf(this.task) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CronConfig)) {
                    return false;
                }
                CronConfig other = (CronConfig)o;
                return super.equals(other) && Objects.equals(this.expression, other.expression()) && this.concurrentExecution == other.concurrentExecution() && Objects.equals(this.task, other.task());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.expression, this.concurrentExecution, this.task);
            }
        }
    }
}

