/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.scheduling.TaskConfigBlueprint;
import io.helidon.scheduling.TaskConfigDecorator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.scheduling.TaskConfigBlueprint")
public interface TaskConfig
extends TaskConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskConfig instance) {
        return (Builder)TaskConfig.builder().from(instance);
    }

    public static TaskConfig create(Config config) {
        return ((Builder)TaskConfig.builder().config(config)).buildPrototype();
    }

    public static TaskConfig create() {
        return TaskConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, TaskConfig>
    implements io.helidon.common.Builder<Builder, TaskConfig> {
        private Builder() {
        }

        public TaskConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TaskConfigImpl(this);
        }

        public TaskConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TaskConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private ScheduledExecutorService executor;

        protected BuilderBase() {
        }

        public BUILDER from(TaskConfig prototype) {
            this.executor(prototype.executor());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.executor().ifPresent(this::executor);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ScheduledExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ScheduledExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "TaskConfigBuilder{executor=" + String.valueOf(this.executor) + "}";
        }

        protected void preBuildPrototype() {
            new TaskConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.executor == null) {
                collector.fatal(this.getClass(), "Property \"executor\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class TaskConfigImpl
        implements TaskConfig {
            private final ScheduledExecutorService executor;

            protected TaskConfigImpl(BuilderBase<?, ?> builder) {
                this.executor = builder.executor().get();
            }

            @Override
            public ScheduledExecutorService executor() {
                return this.executor;
            }

            public String toString() {
                return "TaskConfig{executor=" + String.valueOf(this.executor) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaskConfig)) {
                    return false;
                }
                TaskConfig other = (TaskConfig)o;
                return Objects.equals(this.executor, other.executor());
            }

            public int hashCode() {
                return Objects.hash(this.executor);
            }
        }
    }
}

