/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.Task;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class FixedRateTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(FixedRateTask.class.getName());
    private final AtomicLong iteration = new AtomicLong(0L);
    private ScheduledExecutorService executorService;
    private final long initialDelay;
    private final long delay;
    private final TimeUnit timeUnit;
    private final ScheduledConsumer actualTask;

    FixedRateTask(ScheduledExecutorService executorService, long initialDelay, long delay, TimeUnit timeUnit, ScheduledConsumer actualTask) {
        this.executorService = executorService;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.actualTask = actualTask;
        executorService.scheduleAtFixedRate(this::run, initialDelay, delay, timeUnit);
    }

    @Override
    public String description() {
        String unit = this.timeUnit.toString().toLowerCase();
        if (this.initialDelay == 0L) {
            return String.format("every %s %s", this.delay, unit);
        }
        return String.format("every %s %s with initial delay %s %s", this.delay, unit, this.initialDelay, unit);
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.executorService;
    }

    void run() {
        try {
            final long it = this.iteration.incrementAndGet();
            this.actualTask.run(new FixedRateInvocation(){

                @Override
                public long initialDelay() {
                    return FixedRateTask.this.initialDelay;
                }

                @Override
                public long delay() {
                    return FixedRateTask.this.delay;
                }

                @Override
                public TimeUnit timeUnit() {
                    return FixedRateTask.this.timeUnit;
                }

                @Override
                public long iteration() {
                    return it;
                }

                @Override
                public String description() {
                    return FixedRateTask.this.description();
                }
            });
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e, () -> "Error when invoking scheduled method.");
        }
    }
}

