/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.openapi.OpenApiFormat;
import io.helidon.openapi.OpenApiManager;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

final class SimpleOpenApiManager
implements OpenApiManager<String> {
    private static final System.Logger LOGGER = System.getLogger(SimpleOpenApiManager.class.getName());
    private static final DumperOptions JSON_DUMPER_OPTIONS = SimpleOpenApiManager.jsonDumperOptions();
    private static final DumperOptions YAML_DUMPER_OPTIONS = SimpleOpenApiManager.yamlDumperOptions();

    SimpleOpenApiManager() {
    }

    public String name() {
        return "default";
    }

    public String type() {
        return "default";
    }

    @Override
    public String load(String content) {
        return content;
    }

    @Override
    public String format(String content, OpenApiFormat format) {
        return switch (format) {
            default -> throw new MatchException(null, null);
            case OpenApiFormat.UNSUPPORTED, OpenApiFormat.YAML -> this.toYaml(content);
            case OpenApiFormat.JSON -> this.toJson(content);
        };
    }

    private String toYaml(String rawData) {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Converting OpenAPI document in YAML format");
        }
        Yaml yaml = new Yaml(YAML_DUMPER_OPTIONS);
        Object loadedData = yaml.load(rawData);
        return yaml.dump(loadedData);
    }

    private String toJson(String data) {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Converting OpenAPI document in JSON format");
        }
        Representer representer = new Representer(this, JSON_DUMPER_OPTIONS){

            protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
                if (tag.equals((Object)Tag.BINARY)) {
                    return super.representScalar(Tag.STR, value, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
                }
                if (tag.equals((Object)Tag.BOOL) || tag.equals((Object)Tag.FLOAT) || tag.equals((Object)Tag.INT)) {
                    return super.representScalar(tag, value, DumperOptions.ScalarStyle.PLAIN);
                }
                return super.representScalar(tag, value, style);
            }
        };
        Yaml yaml = new Yaml(representer, JSON_DUMPER_OPTIONS);
        Object loadedData = yaml.load(data);
        return yaml.dump(loadedData);
    }

    private static DumperOptions yamlDumperOptions() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setIndent(2);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return dumperOptions;
    }

    private static DumperOptions jsonDumperOptions() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setSplitLines(false);
        return dumperOptions;
    }
}

