/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.http.BadRequestException;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Status;
import io.helidon.openapi.OpenApiFeatureConfig;
import io.helidon.openapi.OpenApiFormat;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.OpenApiService;
import io.helidon.openapi.SimpleOpenApiManager;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.SecureHandler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.servicecommon.FeatureSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=OpenApiFeatureConfig.class)
public final class OpenApiFeature
implements FeatureSupport,
RuntimeType.Api<OpenApiFeatureConfig> {
    private static final System.Logger LOGGER = System.getLogger(OpenApiFeature.class.getName());
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "META-INF/openapi.";
    private static final Map<String, MediaType> SUPPORTED_FORMATS = Map.of("json", MediaTypes.APPLICATION_JSON, "yaml", MediaTypes.APPLICATION_OPENAPI_YAML, "yml", MediaTypes.APPLICATION_OPENAPI_YAML);
    private static final List<String> DEFAULT_FILE_PATHS = SUPPORTED_FORMATS.keySet().stream().map(fileType -> DEFAULT_STATIC_FILE_PATH_PREFIX + fileType).toList();
    private static final MediaType[] PREFERRED_MEDIA_TYPES = new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML};
    private final String content;
    private final OpenApiFeatureConfig config;
    private final CorsEnabledServiceHelper corsService;
    private final OpenApiManager<?> manager;
    private final LazyValue<Object> model;
    private final ConcurrentMap<OpenApiFormat, String> cachedDocuments = new ConcurrentHashMap<OpenApiFormat, String>();

    public static OpenApiFeatureConfig.Builder builder() {
        return OpenApiFeatureConfig.builder();
    }

    public static OpenApiFeature create() {
        return OpenApiFeature.builder().build();
    }

    public static OpenApiFeature create(Config config) {
        return new OpenApiFeature(OpenApiFeatureConfig.create(config));
    }

    static OpenApiFeature create(OpenApiFeatureConfig config) {
        return new OpenApiFeature(config);
    }

    public static OpenApiFeature create(Consumer<OpenApiFeatureConfig.Builder> builderConsumer) {
        return ((OpenApiFeatureConfig.Builder)OpenApiFeatureConfig.builder().update(builderConsumer)).build();
    }

    OpenApiFeature(OpenApiFeatureConfig config) {
        this.config = config;
        String staticFile = config.staticFile().orElse(null);
        String defaultContent = null;
        if (staticFile != null) {
            defaultContent = OpenApiFeature.readContent(staticFile);
            if (defaultContent == null) {
                defaultContent = "";
                LOGGER.log(System.Logger.Level.WARNING, "Static OpenAPI file not found: {0}", staticFile);
            }
        } else {
            String path;
            Iterator<String> iterator = DEFAULT_FILE_PATHS.iterator();
            while (iterator.hasNext() && (defaultContent = OpenApiFeature.readContent(path = iterator.next())) == null) {
            }
            if (defaultContent == null) {
                defaultContent = "";
                LOGGER.log(System.Logger.Level.WARNING, "Static OpenAPI file not found, checked: {0}", DEFAULT_FILE_PATHS);
            }
        }
        this.content = defaultContent;
        this.manager = config.manager().orElseGet(SimpleOpenApiManager::new);
        this.corsService = CorsEnabledServiceHelper.create((String)"openapi", (CrossOriginConfig)config.cors().orElse(null));
        this.model = LazyValue.create(() -> this.manager.load(this.content));
    }

    public OpenApiFeatureConfig prototype() {
        return this.config;
    }

    public void setup(HttpRouting.Builder routing, HttpRouting.Builder featureRouting) {
        String path = this.prototype().webContext();
        if (!this.config.permitAll()) {
            routing.any(path, new Handler[]{SecureHandler.authorize((String[])this.config.roles().toArray(new String[0]))});
        }
        routing.any(path, new Handler[]{this.corsService.processor()}).get(path, new Handler[]{this::handle});
        this.config.services().forEach(service -> service.setup((HttpRules)routing, path, this::content));
    }

    public String context() {
        return this.config.webContext();
    }

    public String configuredContext() {
        return this.config.webContext();
    }

    public boolean enabled() {
        return this.config.isEnabled();
    }

    public void initialize() {
        this.model.get();
    }

    private void handle(ServerRequest req, ServerResponse res) {
        String format = req.query().first("format").map(String::toLowerCase).orElse(null);
        if (format != null) {
            MediaType contentType = SUPPORTED_FORMATS.get(format.toLowerCase());
            if (contentType == null) {
                throw new BadRequestException(String.format("Unsupported format: %s, supported formats: %s", format, SUPPORTED_FORMATS.keySet()));
            }
            res.status(Status.OK_200);
            res.headers().contentType(contentType);
            res.send((Object)this.content(contentType));
        } else {
            for (OpenApiService service : this.config.services()) {
                if (!service.supports(req.headers())) continue;
                res.next();
                return;
            }
            HttpMediaType contentType = req.headers().bestAccepted(PREFERRED_MEDIA_TYPES).map(HttpMediaType::create).orElse(null);
            if (contentType == null) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Accepted types not supported: {0}", req.headers().acceptedTypes());
                }
                res.next();
                return;
            }
            res.status(Status.OK_200);
            res.headers().contentType((MediaType)contentType);
            res.send((Object)this.content((MediaType)contentType));
        }
    }

    private String content(MediaType mediaType) {
        OpenApiFormat format = OpenApiFormat.valueOf(mediaType);
        if (format == OpenApiFormat.UNSUPPORTED && LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Requested format {0} not supported", mediaType);
        }
        return this.cachedDocuments.computeIfAbsent(format, fmt -> OpenApiFeature.format(this.manager, fmt, this.model.get()));
    }

    private static <T> String format(OpenApiManager<T> manager, OpenApiFormat format, Object model) {
        return manager.format(model, format);
    }

    private static String readContent(String path) {
        String string;
        block9: {
            Path file = Path.of(path, new String[0]);
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readString(file);
            }
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            try {
                String string2 = string = is != null ? new String(is.readAllBytes(), StandardCharsets.UTF_8) : null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }
}

