/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.ServerRequestHeaders;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.Config;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.nima.servicecommon.HelidonFeatureSupport;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRules;
import io.helidon.nima.webserver.http.HttpService;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.helidon.openapi.OpenApiStaticFile;
import io.helidon.openapi.OpenApiUi;
import io.helidon.openapi.SeOpenApiFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public abstract class OpenApiFeature
extends HelidonFeatureSupport {
    public static final MediaType DEFAULT_RESPONSE_MEDIA_TYPE = MediaTypes.APPLICATION_OPENAPI_YAML;
    public static final String FEATURE_NAME = "OpenAPI";
    public static final String DEFAULT_CONTEXT = "/openapi";
    static final String OPENAPI_ENDPOINT_FORMAT_QUERY_PARAMETER = "format";
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "META-INF/openapi.";
    private static final String OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using specified OpenAPI static file %s";
    private static final String OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using default OpenAPI static file %s";
    private final OpenApiStaticFile openApiStaticFile;
    private final OpenApiUi ui;
    private final MediaType[] preferredMediaTypeOrdering;
    private final MediaType[] mediaTypesSupportedByUi;
    private final ConcurrentMap<OpenAPIMediaType, String> cachedDocuments = new ConcurrentHashMap<OpenAPIMediaType, String>();

    public static Builder<?, ?> builder() {
        return new SeOpenApiFeature.Builder();
    }

    protected OpenApiFeature(System.Logger logger, Builder<?, ?> builder) {
        super(logger, builder, FEATURE_NAME);
        this.openApiStaticFile = builder.staticFile();
        this.ui = this.prepareUi(builder);
        this.mediaTypesSupportedByUi = this.ui.supportedMediaTypes();
        this.preferredMediaTypeOrdering = OpenApiFeature.preparePreferredMediaTypeOrdering(this.mediaTypesSupportedByUi);
    }

    public Optional<HttpService> service() {
        return this.enabled() ? Optional.of(this::configureRoutes) : Optional.empty();
    }

    protected abstract String openApiContent(OpenAPIMediaType var1);

    protected Optional<OpenApiStaticFile> staticContent() {
        return Optional.ofNullable(this.openApiStaticFile);
    }

    private OpenApiUi prepareUi(Builder<?, ?> builder) {
        return builder.uiBuilder.build(this::prepareDocument, this.context());
    }

    private static MediaType[] preparePreferredMediaTypeOrdering(MediaType[] uiTypesSupported) {
        int nonTextLength = OpenAPIMediaType.preferredOrdering().length;
        MediaType[] result = Arrays.copyOf(OpenAPIMediaType.preferredOrdering(), nonTextLength + uiTypesSupported.length);
        System.arraycopy(uiTypesSupported, 0, result, nonTextLength, uiTypesSupported.length);
        return result;
    }

    private void configureRoutes(HttpRules rules) {
        rules.get("/", new Handler[]{this::prepareResponse});
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String typeFromPath(String staticFileNamePath) {
        if (staticFileNamePath == null) {
            throw new IllegalArgumentException("File path does not seem to have a file name value but one is expected");
        }
        return staticFileNamePath.substring(staticFileNamePath.lastIndexOf(".") + 1);
    }

    private void prepareResponse(ServerRequest req, ServerResponse resp) {
        try {
            Optional<MediaType> requestedMediaType = this.chooseResponseMediaType(req);
            if (requestedMediaType.isPresent() && this.uiSupportsMediaType(requestedMediaType.get()) && this.ui.prepareTextResponseFromMainEndpoint(req, resp)) {
                return;
            }
            if (requestedMediaType.isEmpty()) {
                this.logger().log(System.Logger.Level.TRACE, () -> String.format("Did not recognize requested media type %s; passing the request on", req.headers().acceptedTypes()));
                return;
            }
            MediaType resultMediaType = requestedMediaType.get();
            String openAPIDocument = this.prepareDocument(resultMediaType);
            resp.status(Http.Status.OK_200);
            resp.headers().contentType(resultMediaType);
            resp.send((Object)openAPIDocument);
        }
        catch (Exception ex) {
            resp.status(Http.Status.INTERNAL_SERVER_ERROR_500);
            resp.send((Object)("Error serializing OpenAPI document; " + ex.getMessage()));
            this.logger().log(System.Logger.Level.ERROR, "Error serializing OpenAPI document", (Throwable)ex);
        }
    }

    private boolean uiSupportsMediaType(MediaType mediaType) {
        HttpMediaType httpMediaType = HttpMediaType.create((MediaType)mediaType);
        for (MediaType uiSupportedMediaType : this.mediaTypesSupportedByUi) {
            if (!httpMediaType.test(uiSupportedMediaType)) continue;
            return true;
        }
        return false;
    }

    private String prepareDocument(MediaType resultMediaType) {
        OpenAPIMediaType matchingOpenApiMediaType = OpenAPIMediaType.byMediaType(resultMediaType).orElseGet(() -> {
            this.logger().log(System.Logger.Level.TRACE, () -> String.format("Requested media type %s not supported; using default", resultMediaType.toString()));
            return OpenAPIMediaType.DEFAULT_TYPE;
        });
        return this.cachedDocuments.computeIfAbsent(matchingOpenApiMediaType, fmt -> {
            String r = this.openApiContent((OpenAPIMediaType)((Object)fmt));
            this.logger().log(System.Logger.Level.TRACE, "Created and cached OpenAPI document in {0} format", fmt.toString());
            return r;
        });
    }

    private Optional<MediaType> chooseResponseMediaType(ServerRequest req) {
        Optional queryParameterFormat = req.query().first(OPENAPI_ENDPOINT_FORMAT_QUERY_PARAMETER);
        if (queryParameterFormat.isPresent()) {
            String queryParameterFormatValue = (String)queryParameterFormat.get();
            try {
                return Optional.of(QueryParameterRequestedFormat.chooseFormat(queryParameterFormatValue).mediaType());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Query parameter 'format' had value '" + queryParameterFormatValue + "' but expected " + Arrays.toString((Object[])QueryParameterRequestedFormat.values()));
            }
        }
        ServerRequestHeaders headersToCheck = req.headers();
        if (headersToCheck.acceptedTypes().isEmpty()) {
            WritableHeaders writableHeaders = WritableHeaders.create((Headers)headersToCheck);
            writableHeaders.add(Http.Header.ACCEPT, new String[]{DEFAULT_RESPONSE_MEDIA_TYPE.toString()});
            headersToCheck = ServerRequestHeaders.create((Headers)writableHeaders);
        }
        return headersToCheck.bestAccepted(this.preferredMediaTypeOrdering);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends OpenApiFeature>
    extends HelidonFeatureSupport.Builder<B, T> {
        public static final String CONFIG_KEY = "openapi";
        private OpenApiStaticFile staticFile;
        private OpenApiUi.Builder<?, ?> uiBuilder = OpenApiUi.builder();

        protected Builder() {
            super(OpenApiFeature.DEFAULT_CONTEXT);
        }

        protected abstract System.Logger logger();

        public B config(Config config) {
            super.config((io.helidon.common.config.Config)config);
            config.get("static-file").asString().ifPresent(this::staticFile);
            config.get("ui").ifExists(this.uiBuilder::config);
            return (B)((Object)((Builder)this.identity()));
        }

        @ConfiguredOption(value="META-INF/openapi.*")
        public B staticFile(String path) {
            Objects.requireNonNull(path, "path to static file must be non-null");
            OpenAPIMediaType openApiMediaType = OpenAPIMediaType.byFileType(OpenApiFeature.typeFromPath(path)).orElseThrow(() -> new IllegalArgumentException("Static file " + path + " not recognized as YAML or JSON"));
            this.staticFile = OpenApiStaticFile.create(openApiMediaType, this.explicitStaticFileContentFromPath(path));
            return (B)((Object)((Builder)this.identity()));
        }

        @ConfiguredOption(type=OpenApiUi.class)
        public B ui(OpenApiUi.Builder<?, ?> uiBuilder) {
            Objects.requireNonNull(uiBuilder, "UI must be non-null");
            this.uiBuilder = uiBuilder;
            return (B)((Object)((Builder)this.identity()));
        }

        public OpenApiStaticFile staticFile() {
            return this.staticFile == null ? this.getDefaultStaticFile() : this.staticFile;
        }

        private OpenApiStaticFile getDefaultStaticFile() {
            OpenApiStaticFile result = null;
            ArrayList<CallSite> candidatePaths = this.logger().isLoggable(System.Logger.Level.TRACE) ? new ArrayList<CallSite>() : null;
            for (OpenAPIMediaType candidate : OpenAPIMediaType.values()) {
                for (String type : candidate.matchingTypes()) {
                    String content;
                    String candidatePath = OpenApiFeature.DEFAULT_STATIC_FILE_PATH_PREFIX + type;
                    if (candidatePaths != null) {
                        candidatePaths.add((CallSite)((Object)candidatePath));
                    }
                    if ((content = this.defaultStaticFileContentFromPath(candidatePath)) == null) continue;
                    result = OpenApiStaticFile.create(candidate, content);
                }
            }
            if (candidatePaths != null) {
                this.logger().log(System.Logger.Level.TRACE, candidatePaths.stream().collect(Collectors.joining(",", "No default static OpenAPI description file found; checked [", "]")));
            }
            return result;
        }

        private String defaultStaticFileContentFromPath(String candidatePath) {
            return this.staticFileContentFromPath(candidatePath, OpenApiFeature.OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT);
        }

        private String explicitStaticFileContentFromPath(String candidatePath) {
            return this.staticFileContentFromPath(candidatePath, OpenApiFeature.OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT);
        }

        private String staticFileContentFromPath(String candidatePath, String logMessage) {
            InputStream is = OpenApiFeature.getContextClassLoader().getResourceAsStream(candidatePath);
            if (is != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
                try {
                    Path path = Paths.get(candidatePath, new String[0]);
                    this.logger().log(System.Logger.Level.TRACE, () -> String.format(logMessage, path.toAbsolutePath()));
                    StringBuilder result = new StringBuilder();
                    CharBuffer charBuffer = CharBuffer.allocate(512);
                    while (reader.read(charBuffer) != -1) {
                        charBuffer.flip();
                        result.append(charBuffer);
                    }
                    string = result.toString();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Error preparing to read from path " + candidatePath, ex);
                    }
                }
                ((Reader)reader).close();
                return string;
            }
            return null;
        }
    }

    public static enum OpenAPIMediaType {
        JSON(new MediaType[]{MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON}, "json"),
        YAML(new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.TEXT_PLAIN, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML}, "yaml", "yml");

        public static final OpenAPIMediaType DEFAULT_TYPE;
        static final String TYPE_LIST = "json|yaml|yml";
        private final List<String> fileTypes;
        private final List<MediaType> mediaTypes;

        private OpenAPIMediaType(MediaType[] mediaTypes, String ... fileTypes) {
            this.mediaTypes = Arrays.asList(mediaTypes);
            this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        }

        public List<String> matchingTypes() {
            return this.fileTypes;
        }

        public static Optional<OpenAPIMediaType> byFileType(String fileType) {
            for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
                if (!candidateType.matchingTypes().contains(fileType)) continue;
                return Optional.of(candidateType);
            }
            return Optional.empty();
        }

        public static Optional<OpenAPIMediaType> byMediaType(MediaType mt) {
            for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
                if (!candidateType.mediaTypes.contains(mt)) continue;
                return Optional.of(candidateType);
            }
            return Optional.empty();
        }

        public static List<String> recognizedFileTypes() {
            ArrayList<String> result = new ArrayList<String>();
            for (OpenAPIMediaType type : OpenAPIMediaType.values()) {
                result.addAll(type.fileTypes);
            }
            return result;
        }

        public static MediaType[] preferredOrdering() {
            return new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML, MediaTypes.TEXT_PLAIN};
        }

        static {
            DEFAULT_TYPE = YAML;
        }
    }

    static enum QueryParameterRequestedFormat {
        JSON(MediaTypes.APPLICATION_JSON),
        YAML(MediaTypes.APPLICATION_OPENAPI_YAML);

        private final MediaType mt;

        static QueryParameterRequestedFormat chooseFormat(String format) {
            return QueryParameterRequestedFormat.valueOf(format);
        }

        private QueryParameterRequestedFormat(MediaType mt) {
            this.mt = mt;
        }

        MediaType mediaType() {
            return this.mt;
        }
    }
}

