/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.LazyValue;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.openapi.OpenAPISupport;
import io.helidon.openapi.OpenApiUi;
import io.helidon.openapi.OpenApiUiFactory;
import io.helidon.openapi.OpenApiUiNoOpFactory;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OpenApiUiBase
implements OpenApiUi {
    private static final Logger LOGGER = Logger.getLogger(OpenApiUiBase.class.getName());
    private static final LazyValue<OpenApiUiFactory<?, ?>> UI_FACTORY = LazyValue.create(OpenApiUiBase::loadUiFactory);
    private static final String HTML_PREFIX = "<!doctype html>\n<html lang=\"en-US\">\n    <head>\n        <meta charset=\"utf-8\"/>\n        <title>OpenAPI Document</title>\n    </head>\n    <body>\n        <pre>\n";
    private static final String HTML_SUFFIX = "        </pre>\n    </body>\n</html>\n";
    private final Map<MediaType, String> preparedDocuments = new HashMap<MediaType, String>();
    private final boolean isEnabled;
    private final Function<MediaType, String> documentPreparer;
    private final String webContext;
    private final Map<String, String> options = new HashMap<String, String>();

    static OpenApiUi.Builder<?, ?> builder() {
        return ((OpenApiUiFactory)UI_FACTORY.get()).builder();
    }

    protected OpenApiUiBase(Builder<?, ?> builder, Function<MediaType, String> documentPreparer, String openAPIWebContext) {
        Objects.requireNonNull(builder.documentPreparer, "Builder's documentPreparer must be non-null");
        Objects.requireNonNull(builder.openApiSupportWebContext, "Builder's OpenAPISupport web context must be non-null");
        this.documentPreparer = documentPreparer;
        this.isEnabled = builder.isEnabled;
        this.webContext = (String)((Object)Objects.requireNonNullElse(builder.webContext, openAPIWebContext + "/ui"));
        this.options.putAll(builder.options);
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected String prepareDocument(MediaType mediaType) {
        return this.documentPreparer.apply(mediaType);
    }

    protected String webContext() {
        return this.webContext;
    }

    protected Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    protected boolean sendStaticText(ServerRequest request, ServerResponse response, MediaType mediaType) {
        try {
            response.addHeader("Content-Type", new String[]{mediaType.toString()}).send((Object)this.prepareDocument(request.queryParams(), mediaType));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error formatting OpenAPI output as " + String.valueOf(mediaType), e);
            response.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500).send((Object)"Error formatting OpenAPI output. See server log.");
        }
        return true;
    }

    private static OpenApiUiFactory<?, ?> loadUiFactory() {
        return (OpenApiUiFactory)HelidonServiceLoader.builder(ServiceLoader.load(OpenApiUiFactory.class)).addService((Object)OpenApiUiNoOpFactory.create(), Integer.MAX_VALUE).build().iterator().next();
    }

    private String prepareDocument(Parameters queryParameters, MediaType mediaType) throws IOException {
        String result = null;
        if (this.preparedDocuments.containsKey(mediaType)) {
            return this.preparedDocuments.get(mediaType);
        }
        MediaType resultMediaType = queryParameters.first("format").map(OpenAPISupport.QueryParameterRequestedFormat::chooseFormat).map(OpenAPISupport.QueryParameterRequestedFormat::mediaType).orElse(mediaType);
        result = this.prepareDocument(resultMediaType);
        if (mediaType.test(MediaType.TEXT_HTML)) {
            result = this.embedInHtml(result);
        }
        this.preparedDocuments.put(resultMediaType, result);
        return result;
    }

    private String embedInHtml(String text) {
        return HTML_PREFIX + text + HTML_SUFFIX;
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends OpenApiUi>
    implements OpenApiUi.Builder<B, T> {
        private final Map<String, String> options = new HashMap<String, String>();
        private boolean isEnabled = true;
        private String webContext;
        private Function<MediaType, String> documentPreparer;
        private String openApiSupportWebContext;

        @Override
        public B options(Map<String, String> options) {
            this.options.putAll(options);
            return (B)((Builder)this.identity());
        }

        @Override
        public B isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return (B)((Builder)this.identity());
        }

        @Override
        public B webContext(String webContext) {
            this.webContext = webContext;
            return (B)((Builder)this.identity());
        }

        @Override
        public B documentPreparer(Function<MediaType, String> documentPreparer) {
            this.documentPreparer = documentPreparer;
            return (B)((Builder)this.identity());
        }

        @Override
        public B openApiSupportWebContext(String openApiWebContext) {
            this.openApiSupportWebContext = openApiWebContext;
            return (B)((Builder)this.identity());
        }

        public String openApiSupportWebContext() {
            return this.openApiSupportWebContext;
        }

        public Function<MediaType, String> documentPreparer() {
            return this.documentPreparer;
        }

        protected Map<String, String> options() {
            return this.options;
        }
    }
}

