/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.media.jsonp.server.JsonSupport;
import io.helidon.openapi.OpenAPIConfigImpl;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;

public class OpenAPISupport
implements Service {
    public static final String DEFAULT_WEB_CONTEXT = "/openapi";
    public static final MediaType DEFAULT_RESPONSE_MEDIA_TYPE = MediaType.APPLICATION_OPENAPI_YAML;
    private static final Logger LOGGER = Logger.getLogger(OpenAPISupport.class.getName());
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "/openapi.";
    private static final String OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using specified OpenAPI static file %s";
    private static final String OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using default OpenAPI static file %s";
    private static final String JANDEX_INDEX_PATH = "/META-INF/jandex.idx";
    private final Optional<String> webContext;
    private final Optional<String> staticFilePath;
    private final OpenApiConfig openAPIConfig;
    private boolean isAnnotationProcessingEnabled = false;
    private final Map<MediaType, String> cachedDocuments = new HashMap<MediaType, String>();

    private OpenAPISupport(Builder builder) {
        this.webContext = builder.webContext;
        this.staticFilePath = builder.staticFilePath;
        this.isAnnotationProcessingEnabled = builder.isAnnotationProcessingEnabled;
        this.openAPIConfig = builder.apiConfigBuilder.build();
    }

    public void update(Routing.Rules rules) {
        try {
            this.initializeOpenAPIDocument(this.openAPIConfig);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error initializing OpenAPI information", ex);
        }
        String webContextPath = this.webContext.orElse(DEFAULT_WEB_CONTEXT);
        if (this.webContext.isPresent()) {
            LOGGER.log(Level.FINE, "OpenAPI path set to {0}", webContextPath);
        } else {
            LOGGER.log(Level.FINE, "OpenAPI path defaulting to {0}", webContextPath);
        }
        rules.get(new Handler[]{JsonSupport.create()}).get(webContextPath, new Handler[]{this::prepareResponse});
    }

    void initializeOpenAPIDocument(OpenApiConfig config) throws IOException {
        try (OpenApiStaticFile staticFile = this.buildOpenAPIStaticFile();){
            OpenApiDocument.INSTANCE.reset();
            OpenApiDocument.INSTANCE.config(config);
            OpenApiDocument.INSTANCE.modelFromReader((OpenAPI)OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
            OpenApiDocument.INSTANCE.modelFromStaticFile((OpenAPI)OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
            if (this.isAnnotationProcessingEnabled) {
                this.expandModelUsingAnnotations(config);
            } else {
                LOGGER.log(Level.FINE, "OpenAPI Annotation processing is disabled");
            }
            OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
            OpenApiDocument.INSTANCE.initialize();
        }
    }

    private void expandModelUsingAnnotations(OpenApiConfig config) throws IOException {
        try (InputStream jandexIS = this.getClass().getResourceAsStream(JANDEX_INDEX_PATH);){
            if (jandexIS == null) {
                LOGGER.log(Level.FINE, "OpenAPI Annotation processing enabled but jandex index {0} not found; continuing without scanning for OpenAPI-related annotations", JANDEX_INDEX_PATH);
                return;
            }
            LOGGER.log(Level.FINE, "Using Jandex index at {0}", JANDEX_INDEX_PATH);
            IndexReader ir = new IndexReader(jandexIS);
            OpenApiDocument.INSTANCE.modelFromAnnotations((OpenAPI)OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (IndexView)ir.read()));
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private OpenApiStaticFile buildOpenAPIStaticFile() {
        return this.staticFilePath.isPresent() ? this.getExplicitStaticFile() : this.getDefaultStaticFile();
    }

    private OpenApiStaticFile getExplicitStaticFile() {
        InputStream is;
        Path path = Paths.get(this.staticFilePath.get(), new String[0]);
        String specifiedFileType = this.typeFromPath(path);
        OpenAPIMediaTypes specifiedMediaType = OpenAPIMediaTypes.byFileType(specifiedFileType);
        if (specifiedMediaType == null) {
            throw new IllegalArgumentException("OpenAPI file path " + path.toAbsolutePath().toString() + " is not one of recognized types: " + OpenAPIMediaTypes.recognizedFileTypes());
        }
        try {
            is = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("OpenAPI file " + path.toAbsolutePath().toString() + " was specified but was not found");
        }
        try {
            LOGGER.log(Level.FINE, () -> String.format(OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
            return new OpenApiStaticFile(is, specifiedMediaType.format());
        }
        catch (Throwable th) {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Encountered an error closing an input stream after catching an unrelated error", ex);
            }
            throw th;
        }
    }

    private String typeFromPath(Path path) {
        Path staticFileNamePath = path.getFileName();
        if (staticFileNamePath == null) {
            throw new IllegalArgumentException("File path " + path.toAbsolutePath().toString() + " does not seem to have a file name value but one is expected");
        }
        String pathText = staticFileNamePath.toString();
        String specifiedFileType = pathText.substring(pathText.lastIndexOf(".") + 1);
        return specifiedFileType;
    }

    private OpenApiStaticFile getDefaultStaticFile() {
        ArrayList<String> candidatePaths = LOGGER.isLoggable(Level.FINER) ? new ArrayList<String>() : null;
        for (OpenAPIMediaTypes candidate : OpenAPIMediaTypes.values()) {
            for (String type : candidate.matchingTypes()) {
                String candidatePath = DEFAULT_STATIC_FILE_PATH_PREFIX + type;
                InputStream is = null;
                try {
                    is = this.getClass().getResourceAsStream(candidatePath);
                    if (is != null) {
                        Path path = Paths.get(candidatePath, new String[0]);
                        LOGGER.log(Level.FINE, () -> String.format(OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
                        return new OpenApiStaticFile(is, candidate.format());
                    }
                    if (candidatePaths == null) continue;
                    candidatePaths.add(candidatePath);
                }
                catch (Throwable th) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.FINE, "Encountered an error closing an input stream after catching an unrelated error", ex);
                        }
                    }
                    throw th;
                }
            }
        }
        if (candidatePaths != null) {
            LOGGER.log(Level.FINER, candidatePaths.stream().collect(Collectors.joining("No default static OpenAPI description file found; checked [", ",", "]")));
        }
        return null;
    }

    private void prepareResponse(ServerRequest req, ServerResponse resp) {
        try {
            MediaType resultMediaType = this.chooseResponseMediaType(req);
            String openAPIDocument = this.prepareDocument(resultMediaType);
            resp.status((Http.ResponseStatus)Http.Status.OK_200);
            resp.headers().add("Content-Type", new String[]{resultMediaType.toString()});
            resp.send((Object)openAPIDocument);
        }
        catch (IOException ex) {
            resp.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
            resp.send((Object)"Error serializing OpenAPI document");
            LOGGER.log(Level.SEVERE, "Error serializing OpenAPI document", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String prepareDocument(MediaType resultMediaType) throws IOException {
        if (!OpenApiDocument.INSTANCE.isSet()) {
            throw new IllegalStateException("OpenApiDocument used but has not been initialized");
        }
        Map<MediaType, String> map = this.cachedDocuments;
        synchronized (map) {
            String result = this.cachedDocuments.get(resultMediaType);
            if (result == null) {
                OpenApiSerializer.Format resultFormat = OpenAPIMediaTypes.byMediaType(resultMediaType).format();
                result = OpenApiSerializer.serialize((OpenAPI)OpenApiDocument.INSTANCE.get(), (OpenApiSerializer.Format)resultFormat);
                this.cachedDocuments.put(resultMediaType, result);
                LOGGER.log(Level.FINER, "Created and cached OpenAPI document in {0} format", resultFormat.toString());
            } else {
                LOGGER.log(Level.FINER, "Using previously-cached OpenAPI document in {0} format", OpenAPIMediaTypes.DEFAULT_TYPE.toString());
            }
            return result;
        }
    }

    private MediaType chooseResponseMediaType(ServerRequest req) {
        MediaType resultMediaType = req.headers().bestAccepted(OpenAPIMediaTypes.preferredOrdering()).orElse(DEFAULT_RESPONSE_MEDIA_TYPE);
        return resultMediaType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OpenAPISupport create() {
        return OpenAPISupport.builder().build();
    }

    public static OpenAPISupport create(Config config) {
        return OpenAPISupport.builder().config(config).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<OpenAPISupport> {
        private static final String CONFIG_PREFIX = "openapi";
        private final OpenAPIConfigImpl.Builder apiConfigBuilder = OpenAPIConfigImpl.builder();
        private Optional<String> webContext = Optional.empty();
        private Optional<String> staticFilePath = Optional.empty();
        private boolean isAnnotationProcessingEnabled = false;

        private Builder() {
        }

        public OpenAPISupport build() {
            return new OpenAPISupport(this);
        }

        public Builder config(Config config) {
            config.get("openapi.web-context").asString().ifPresent(this::webContext);
            config.get("openapi.static-file").asString().ifPresent(this::staticFile);
            this.apiConfigBuilder.config(config);
            return this;
        }

        public Builder webContext(String path) {
            this.webContext = Optional.of(path);
            return this;
        }

        public Builder staticFile(String path) {
            Objects.requireNonNull(path, "path to static file must be non-null");
            this.staticFilePath = Optional.of(path);
            return this;
        }

        public Builder modelReader(String className) {
            Objects.requireNonNull(className, "modelReader class name must be non-null");
            this.apiConfigBuilder.modelReader(className);
            return this;
        }

        public Builder filter(String className) {
            Objects.requireNonNull(className, "filter class name must be non-null");
            this.apiConfigBuilder.filter(className);
            return this;
        }

        public Builder servers(String serverList) {
            Objects.requireNonNull(serverList, "serverList must be non-null");
            this.apiConfigBuilder.servers(serverList);
            return this;
        }

        public Builder addOperationServer(String operationID, String operationServer) {
            Objects.requireNonNull(operationID, "operationID must be non-null");
            Objects.requireNonNull(operationServer, "operationServer must be non-null");
            this.apiConfigBuilder.addOperationServer(operationID, operationServer);
            return this;
        }

        public Builder addPathServer(String path, String pathServer) {
            Objects.requireNonNull(path, "path must be non-null");
            Objects.requireNonNull(pathServer, "pathServer must be non-null");
            this.apiConfigBuilder.addPathServer(path, pathServer);
            return this;
        }

        public Builder enableAnnotationProcessing(boolean isEnabled) {
            this.isAnnotationProcessingEnabled = isEnabled;
            return this;
        }
    }

    private static enum OpenAPIMediaTypes {
        JSON(OpenApiSerializer.Format.JSON, new MediaType[]{MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON}, "json"),
        YAML(OpenApiSerializer.Format.YAML, new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_YAML}, "yaml", "yml");

        private static final OpenAPIMediaTypes DEFAULT_TYPE;
        private final OpenApiSerializer.Format format;
        private final List<String> fileTypes;
        private final List<MediaType> mediaTypes;

        private OpenAPIMediaTypes(OpenApiSerializer.Format format, MediaType[] mediaTypes, String ... fileTypes) {
            this.format = format;
            this.mediaTypes = Arrays.asList(mediaTypes);
            this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        }

        private OpenApiSerializer.Format format() {
            return this.format;
        }

        private List<String> matchingTypes() {
            return this.fileTypes;
        }

        private static OpenAPIMediaTypes byFileType(String fileType) {
            for (OpenAPIMediaTypes candidateType : OpenAPIMediaTypes.values()) {
                if (!candidateType.matchingTypes().contains(fileType)) continue;
                return candidateType;
            }
            return null;
        }

        private static OpenAPIMediaTypes byMediaType(MediaType mt) {
            for (OpenAPIMediaTypes candidateType : OpenAPIMediaTypes.values()) {
                if (!candidateType.mediaTypes.contains(mt)) continue;
                return candidateType;
            }
            return null;
        }

        private static List<String> recognizedFileTypes() {
            ArrayList<String> result = new ArrayList<String>();
            for (OpenAPIMediaTypes type : OpenAPIMediaTypes.values()) {
                result.addAll(type.fileTypes);
            }
            return result;
        }

        private static MediaType[] preferredOrdering() {
            return new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_YAML, MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON};
        }

        static {
            DEFAULT_TYPE = YAML;
        }
    }
}

