/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.common.Weight;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.DirectHandler;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RequestException;
import io.helidon.http.WritableHeaders;
import io.helidon.microprofile.tyrus.TyrusCdiExtension;
import io.helidon.microprofile.tyrus.TyrusConnection;
import io.helidon.microprofile.tyrus.TyrusRoute;
import io.helidon.microprofile.tyrus.TyrusRouting;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.websocket.WsConfig;
import io.helidon.webserver.websocket.WsUpgrader;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Extension;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;

@Weight(value=200.0)
public class TyrusUpgrader
extends WsUpgrader {
    private static final System.Logger LOGGER = System.getLogger(TyrusUpgrader.class.getName());
    private final EngineHolder engine = new EngineHolder();

    private TyrusUpgrader(WsConfig origins) {
        super(origins);
    }

    public static TyrusUpgrader create(WsConfig config) {
        return new TyrusUpgrader(config);
    }

    public ServerConnection upgrade(ConnectionContext ctx, HttpPrologue prologue, WritableHeaders<?> headers) {
        if (!headers.contains(WS_KEY)) {
            return null;
        }
        String wsKey = (String)headers.get(WS_KEY).get();
        String version = headers.contains(WS_VERSION) ? (String)headers.get(WS_VERSION).get() : "13";
        if (!"13".equals(version)) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Unsupported WebSocket Version").header(SUPPORTED_VERSION_HEADER).build();
        }
        String path = prologue.uriPath().path();
        UriQuery query = prologue.query();
        TyrusRouting routing = (TyrusRouting)ctx.router().routing(TyrusRouting.class, null);
        if (routing == null) {
            return null;
        }
        TyrusRoute route = routing.findRoute(prologue);
        if (route == null) {
            return null;
        }
        if (!this.anyOrigin() && headers.contains(HeaderNames.ORIGIN)) {
            String origin = (String)headers.get(HeaderNames.ORIGIN).get();
            if (!this.origins().contains(origin)) {
                throw RequestException.builder().message("Invalid Origin").type(DirectHandler.EventType.FORBIDDEN).build();
            }
        }
        WebSocketEngine.UpgradeInfo upgradeInfo = this.protocolHandshake(routing, headers, query, path);
        DataWriter dataWriter = ctx.dataWriter();
        String switchingProtocols = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: websocket\r\nSec-WebSocket-Accept: " + this.hash(ctx, wsKey) + "\r\n\r\n";
        dataWriter.write(BufferData.create((byte[])switchingProtocols.getBytes(StandardCharsets.US_ASCII)));
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Upgraded to websocket version " + version);
        }
        return new TyrusConnection(ctx, upgradeInfo);
    }

    protected Set<String> origins() {
        return super.origins();
    }

    WebSocketEngine.UpgradeInfo protocolHandshake(TyrusRouting routing, WritableHeaders<?> headers, UriQuery uriQuery, String path) {
        LOGGER.log(System.Logger.Level.DEBUG, "Initiating WebSocket handshake with Tyrus...");
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        for (String name : uriQuery.names()) {
            paramsMap.put(name, uriQuery.all(name).toArray(new String[0]));
        }
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(path)).queryString(uriQuery.rawValue()).parameterMap(paramsMap).build();
        headers.forEach(e -> requestContext.getHeaders().put(e.name(), List.of(e.values())));
        TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
        WebSocketEngine.UpgradeInfo upgradeInfo = this.engine.get(routing).upgrade((UpgradeRequest)requestContext, (UpgradeResponse)upgradeResponse);
        upgradeResponse.getHeaders().forEach((key, value) -> headers.add(HeaderValues.create((HeaderName)HeaderNames.create((String)key, (String)key.toLowerCase(Locale.ROOT)), (Collection)value)));
        return upgradeInfo;
    }

    private static final class EngineHolder {
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private volatile WebSocketEngine engine;

        private EngineHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WebSocketEngine get(TyrusRouting routing) {
            try {
                this.rwLock.readLock().lock();
                if (this.engine != null) {
                    WebSocketEngine webSocketEngine = this.engine;
                    return webSocketEngine;
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            try {
                this.rwLock.writeLock().lock();
                if (this.engine != null) {
                    WebSocketEngine webSocketEngine = this.engine;
                    return webSocketEngine;
                }
                WebSocketEngine webSocketEngine = this.engine = this.createTyrusEngine(routing);
                return webSocketEngine;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        private WebSocketEngine createTyrusEngine(TyrusRouting routing) {
            TyrusCdiExtension extension = (TyrusCdiExtension)CDI.current().select(TyrusCdiExtension.class, new Annotation[0]).get();
            Objects.requireNonNull(extension);
            TyrusServerContainer tyrusServerContainer = this.initializeTyrus(routing);
            return tyrusServerContainer.getWebSocketEngine();
        }

        private TyrusServerContainer initializeTyrus(final TyrusRouting tyrusRouting) {
            Set allEndpointClasses = tyrusRouting.routes().stream().map(TyrusRoute::endpointClass).collect(Collectors.toSet());
            TyrusServerContainer tyrusServerContainer = new TyrusServerContainer(this, allEndpointClasses){
                private final WebSocketEngine engine;
                {
                    super(arg0);
                    this.engine = TyrusWebSocketEngine.builder((WebSocketContainer)this).build();
                }

                public void register(Class<?> endpointClass) {
                    throw new UnsupportedOperationException("Cannot register endpoint class");
                }

                public void register(ServerEndpointConfig serverEndpointConfig) {
                    throw new UnsupportedOperationException("Cannot register ServerEndpointConfig");
                }

                public Set<Extension> getInstalledExtensions() {
                    return tyrusRouting.extensions();
                }

                public WebSocketEngine getWebSocketEngine() {
                    return this.engine;
                }
            };
            WebSocketEngine engine = tyrusServerContainer.getWebSocketEngine();
            tyrusRouting.routes().forEach(route -> {
                try {
                    if (route.serverEndpointConfig() != null) {
                        LOGGER.log(System.Logger.Level.DEBUG, () -> "Registering ws endpoint " + route.path() + route.serverEndpointConfig().getPath());
                        engine.register(route.serverEndpointConfig(), route.path());
                    } else {
                        LOGGER.log(System.Logger.Level.DEBUG, () -> "Registering annotated ws endpoint " + route.path());
                        engine.register(route.endpointClass(), route.path());
                    }
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            });
            return tyrusServerContainer;
        }
    }
}

