/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.microprofile.tyrus.TyrusRoute;
import io.helidon.webserver.Routing;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TyrusRouting
implements Routing {
    private static final TyrusRouting EMPTY = TyrusRouting.builder().build();
    private final Set<Extension> extensions;
    private final List<TyrusRoute> routes;

    private TyrusRouting(Builder builder) {
        this.routes = builder.routes;
        this.extensions = builder.extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TyrusRouting empty() {
        return EMPTY;
    }

    Set<Extension> extensions() {
        return this.extensions;
    }

    List<TyrusRoute> routes() {
        return this.routes;
    }

    TyrusRoute findRoute(HttpPrologue prologue) {
        for (TyrusRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route;
        }
        return null;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Routing> {
        private final List<TyrusRoute> routes = new ArrayList<TyrusRoute>();
        private final Set<Extension> extensions = new HashSet<Extension>();

        private Builder() {
        }

        public Builder endpoint(String path, Class<?> endpointClass) {
            this.routes.add(new TyrusRoute(path, endpointClass, null, PathMatchers.pattern((String)Builder.pathConcat(path, Builder.serverEndpoint(endpointClass)))));
            return this;
        }

        public Builder endpoint(Class<?> endpointClass) {
            return this.endpoint("/", endpointClass);
        }

        public Builder endpoint(String path, ServerEndpointConfig serverEndpointConfig) {
            this.routes.add(new TyrusRoute(path, null, serverEndpointConfig, PathMatchers.pattern((String)Builder.pathConcat(path, serverEndpointConfig.getPath()))));
            return this;
        }

        public Builder endpoint(ServerEndpointConfig serverEndpointConfig) {
            return this.endpoint("/", serverEndpointConfig);
        }

        public Builder extension(Extension extension) {
            this.extensions.add(extension);
            return this;
        }

        public TyrusRouting build() {
            return new TyrusRouting(this);
        }

        private static String pathConcat(String rootPath, String path) {
            StringBuilder result = new StringBuilder();
            if (rootPath.equals("/")) {
                rootPath = "";
            } else if (!rootPath.startsWith("/")) {
                result.append("/");
            }
            result.append(rootPath);
            if (!rootPath.endsWith("/") && !path.startsWith("/")) {
                result.append("/");
            }
            result.append(path);
            return result.toString();
        }

        private static String serverEndpoint(Class<?> endpointClass) {
            ServerEndpoint annot = endpointClass.getAnnotation(ServerEndpoint.class);
            if (annot == null) {
                throw new IllegalArgumentException("Endpoint class " + endpointClass.getName() + " missing @ServerEndpoint");
            }
            return annot.value();
        }
    }
}

