/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.testing.AddBean;
import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.AddConfigBlocks;
import io.helidon.microprofile.testing.AddConfigSource;
import io.helidon.microprofile.testing.AddConfigs;
import io.helidon.microprofile.testing.AfterStop;
import io.helidon.microprofile.testing.Configuration;
import io.helidon.microprofile.testing.HelidonTestConfig;
import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.HelidonTestScope;
import io.helidon.microprofile.testing.HelidonTestScoped;
import io.helidon.microprofile.testing.ReflectionHelper;
import io.helidon.microprofile.testing.Socket;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class HelidonTestExtension
implements Extension {
    private static final Map<Class<? extends Annotation>, Annotation> ANNOTATION_LITERALS = Map.of(ApplicationScoped.class, ApplicationScoped.Literal.INSTANCE, Singleton.class, ApplicationScoped.Literal.INSTANCE, RequestScoped.class, RequestScoped.Literal.INSTANCE, Dependent.class, Dependent.Literal.INSTANCE);
    private static final Set<Class<? extends Annotation>> TYPE_ANNOTATION_TYPES = Set.of(AddConfig.class, AddConfigs.class, AddConfigBlock.class, Configuration.class);
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATION_TYPES = Set.of(Socket.class);
    private static final Set<Class<? extends Annotation>> FIELD_ANNOTATION_TYPES = Set.of(Socket.class);
    private static final Set<Class<? extends Annotation>> METHOD_ANNOTATION_TYPES = Set.of(AddConfig.class, AddConfigs.class, AddConfigBlock.class, AddConfigSource.class, AfterStop.class, Configuration.class);
    private final HelidonTestInfo<?> testInfo;
    private final HelidonTestConfig testConfig;
    private final HelidonTestScope testScope;
    private final Map<Annotation, String> sockets = new HashMap<Annotation, String>();
    private final List<Method> afterStop = new ArrayList<Method>();

    protected HelidonTestExtension(HelidonTestInfo<?> testInfo, HelidonTestScope testScope) {
        this.testInfo = testInfo;
        this.testConfig = new HelidonTestConfig(testInfo);
        this.testScope = testScope;
    }

    protected Set<Class<? extends Annotation>> typeAnnotationTypes() {
        return TYPE_ANNOTATION_TYPES;
    }

    protected Set<Class<? extends Annotation>> parameterAnnotationTypes() {
        return PARAMETER_ANNOTATION_TYPES;
    }

    protected Set<Class<? extends Annotation>> fieldAnnotationTypes() {
        return FIELD_ANNOTATION_TYPES;
    }

    protected Set<Class<? extends Annotation>> methodAnnotationTypes() {
        return METHOD_ANNOTATION_TYPES;
    }

    protected void processTypeAnnotation(Annotation annotation) {
        Annotation annotation2 = annotation;
        Objects.requireNonNull(annotation2);
        Annotation annotation3 = annotation2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Configuration.class, AddConfig.class, AddConfigs.class, AddConfigBlock.class, AddConfigBlocks.class}, (Object)annotation3, n)) {
            case 0: {
                Configuration e = (Configuration)annotation3;
                this.processConfiguration(e);
                break;
            }
            case 1: {
                AddConfig e = (AddConfig)annotation3;
                this.processAddConfig(e);
                break;
            }
            case 2: {
                AddConfigs e = (AddConfigs)annotation3;
                this.processAddConfig(e.value());
                break;
            }
            case 3: {
                AddConfigBlock e = (AddConfigBlock)annotation3;
                this.processAddConfigBlock(e);
                break;
            }
            case 4: {
                AddConfigBlocks e = (AddConfigBlocks)annotation3;
                this.processAddConfigBlock(e.value());
                break;
            }
        }
    }

    protected void processParameterAnnotation(Annotation annotation) {
        if (annotation instanceof Socket) {
            Socket s = (Socket)annotation;
            this.processSocket(s, s.value());
        }
    }

    protected void processFieldAnnotation(Annotation annotation) {
        if (annotation instanceof Socket) {
            Socket s = (Socket)annotation;
            this.processSocket(s, s.value());
        }
    }

    protected void processStaticMethodAnnotation(Annotation annotation, Method method) {
        if (annotation instanceof AddConfigSource) {
            this.processAddConfigSource(method);
        } else if (annotation instanceof AfterStop) {
            this.processAfterStop(method);
        } else {
            throw new IllegalStateException(String.format("@%s requires method %s to be non static", method, annotation.annotationType().getSimpleName()));
        }
    }

    protected void processTestMethodAnnotation(Annotation annotation, Method method) {
        Annotation annotation2 = annotation;
        Objects.requireNonNull(annotation2);
        Annotation annotation3 = annotation2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Configuration.class, AddConfig.class, AddConfigs.class, AddConfigBlock.class, AddConfigBlocks.class}, (Object)annotation3, n)) {
            case 0: {
                Configuration e = (Configuration)annotation3;
                this.processConfiguration(e);
                break;
            }
            case 1: {
                AddConfig e = (AddConfig)annotation3;
                this.processAddConfig(e);
                break;
            }
            case 2: {
                AddConfigs e = (AddConfigs)annotation3;
                this.processAddConfig(e.value());
                break;
            }
            case 3: {
                AddConfigBlock e = (AddConfigBlock)annotation3;
                this.processAddConfigBlock(e);
                break;
            }
            case 4: {
                AddConfigBlocks e = (AddConfigBlocks)annotation3;
                this.processAddConfigBlock(e.value());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("@%s requires method %s to be static", method, annotation.annotationType().getSimpleName()));
            }
        }
    }

    protected final void processConfiguration(Configuration annotation) {
        this.testConfig.synthetic().update(annotation);
    }

    protected final void processAddConfig(AddConfig ... annotations) {
        this.testConfig.synthetic().update(annotations);
    }

    protected final void processAddConfigBlock(AddConfigBlock ... annotations) {
        this.testConfig.synthetic().update(annotations);
    }

    protected final void processAddConfigSource(Method method) {
        this.testConfig.synthetic().update(method);
    }

    protected final void processAfterStop(Method method) {
        this.afterStop.add(ReflectionHelper.requireStatic(method));
    }

    protected final void processSocket(Annotation annotation, String value) {
        this.sockets.put(annotation, value);
    }

    private void processTestClass(@Observes @WithAnnotations(value={HelidonTestScoped.class}) ProcessAnnotatedType<?> pat, BeanManager bm) {
        HashSet<AnnotatedType> allTypes = new HashSet<AnnotatedType>();
        allTypes.add(pat.getAnnotatedType());
        for (Class<?> type : ReflectionHelper.typeHierarchy(pat.getAnnotatedType().getJavaClass(), false)) {
            allTypes.add(bm.createAnnotatedType(type));
        }
        Method testMethod = this.testInfo.testMethod().orElse(null);
        for (AnnotatedType type : allTypes) {
            this.processAnnotated((Annotated)type, this.typeAnnotationTypes(), this::processTypeAnnotation);
            for (AnnotatedConstructor constructor : type.getConstructors()) {
                for (AnnotatedParameter parameter : constructor.getParameters()) {
                    this.processAnnotated((Annotated)parameter, this.fieldAnnotationTypes(), this::processParameterAnnotation);
                }
            }
            for (AnnotatedField field : type.getFields()) {
                this.processAnnotated((Annotated)field, this.parameterAnnotationTypes(), this::processFieldAnnotation);
            }
            for (AnnotatedMethod method : type.getMethods()) {
                this.processAnnotated((Annotated)method, this.methodAnnotationTypes(), a -> {
                    if (method.isStatic()) {
                        this.processStaticMethodAnnotation((Annotation)a, method.getJavaMember());
                    } else if (testMethod != null && ReflectionHelper.isOverride(method.getJavaMember(), testMethod)) {
                        this.processTestMethodAnnotation((Annotation)a, method.getJavaMember());
                    }
                });
            }
        }
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager bm) {
        this.testConfig.resolve();
        event.addAnnotatedType(this.testInfo.testClass(), "HelidonTest").add((Annotation)HelidonTestScoped.Literal.INSTANCE);
        for (AddBean addBean : this.testInfo.addBeans()) {
            Class<?> beanClass = addBean.value();
            final Class<? extends Annotation> scopeClass = addBean.scope();
            AnnotatedTypeConfigurator configurator = event.addAnnotatedType(beanClass, beanClass.getName());
            if (!scopeClass.equals(Annotation.class)) {
                Annotation scope = ANNOTATION_LITERALS.get(scopeClass);
                if (scope == null) {
                    scope = new AnnotationLiteral<Annotation>(){

                        public Class<? extends Annotation> annotationType() {
                            return scopeClass;
                        }
                    };
                }
                configurator.remove(a -> bm.isScope(a.annotationType()));
                configurator.add(scope);
                continue;
            }
            AnnotatedType annotated = configurator.getAnnotated();
            if (!annotated.getAnnotations().stream().noneMatch(a -> bm.isScope(a.annotationType()))) continue;
            configurator.add((Annotation)ApplicationScoped.Literal.INSTANCE);
        }
    }

    private void afterBeanDiscovery(@Observes @Priority(value=0) AfterBeanDiscovery event, BeanManager bm) {
        this.testConfig.resolve();
        event.addContext((Context)this.testScope);
        Class<? extends Extension> serverClass = HelidonTestExtension.serverClass();
        if (serverClass != null && (!this.testInfo.disableDiscovery() || this.testInfo.containsExtension(serverClass))) {
            Extension server = bm.getExtension(serverClass);
            Client client = ClientBuilder.newClient();
            event.addBean().addTransitiveTypeClosure(WebTarget.class).scope(ApplicationScoped.class).createWith(c -> client.target("http://localhost:" + HelidonTestExtension.port(server, "@default")));
            this.sockets.forEach((annotation, value) -> {
                Supplier<String> supplier = () -> "http://localhost:" + HelidonTestExtension.port(server, value);
                event.addBean().addTransitiveTypeClosure(WebTarget.class).scope(ApplicationScoped.class).qualifiers(new Annotation[]{annotation}).createWith(c -> client.target((String)supplier.get()));
                LazyValue uri = LazyValue.create(() -> URI.create((String)supplier.get()));
                event.addBean().addType(URI.class).scope(Dependent.class).qualifiers(new Annotation[]{annotation}).createWith(c -> uri.get());
                LazyValue rawUri = LazyValue.create(supplier);
                event.addBean().addType(String.class).scope(Dependent.class).qualifiers(new Annotation[]{annotation}).createWith(c -> rawUri.get());
            });
        }
    }

    private void afterStop(@Observes @Priority(value=4000) @Destroyed(value=ApplicationScoped.class) Object ignored) {
        try {
            this.afterStop.forEach(m -> ReflectionHelper.invoke(Void.class, m, null, new Object[0]));
        }
        finally {
            this.testConfig.restore();
        }
    }

    private void processAnnotated(Annotated elt, Set<Class<? extends Annotation>> types, Consumer<Annotation> action) {
        for (Annotation a : elt.getAnnotations()) {
            if (types.contains(a.annotationType())) {
                action.accept(a);
                continue;
            }
            for (Annotation b : ReflectionHelper.annotationHierarchy(a.annotationType())) {
                if (!types.contains(b.annotationType())) continue;
                action.accept(b);
            }
        }
    }

    private static Class<? extends Extension> serverClass() {
        try {
            return Class.forName("io.helidon.microprofile.server.ServerCdiExtension");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static int port(Extension server, String name) {
        try {
            Method portMethod = server.getClass().getMethod("port", String.class);
            return ReflectionHelper.invoke(Integer.class, portMethod, server, name);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

