/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import io.helidon.microprofile.testing.Instrumented;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.ITestClassConfigInfo;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

record ClassDecorator(ITestClass delegate) implements ITestClass,
ITestClassConfigInfo
{
    private static final Map<ITestClass, ClassDecorator> CACHE = new ConcurrentHashMap<ITestClass, ClassDecorator>();

    static ClassDecorator decorate(ITestClass tc) {
        if (!(tc instanceof ClassDecorator)) {
            return CACHE.computeIfAbsent(tc, ClassDecorator::new);
        }
        ClassDecorator cd = (ClassDecorator)tc;
        return cd;
    }

    public List<ITestNGMethod> getAllBeforeClassMethods() {
        ITestClass iTestClass = this.delegate;
        if (iTestClass instanceof ITestClassConfigInfo) {
            ITestClassConfigInfo info = (ITestClassConfigInfo)iTestClass;
            return info.getAllBeforeClassMethods().stream().peek(m -> m.setTestClass((ITestClass)ClassDecorator.decorate(m.getTestClass()))).toList();
        }
        return List.of();
    }

    public List<ITestNGMethod> getInstanceBeforeClassMethods(Object instance) {
        ITestClass iTestClass = this.delegate;
        if (iTestClass instanceof ITestClassConfigInfo) {
            ITestClassConfigInfo info = (ITestClassConfigInfo)iTestClass;
            return info.getInstanceBeforeClassMethods(instance).stream().peek(m -> m.setTestClass((ITestClass)ClassDecorator.decorate(m.getTestClass()))).toList();
        }
        return List.of();
    }

    public String getName() {
        Class realClass = this.delegate.getRealClass();
        return Instrumented.isInstrumented((Class)realClass) ? realClass.getSuperclass().getName() : realClass.getName();
    }

    public Class<?> getRealClass() {
        Class realClass = this.delegate.getRealClass();
        String callerClass = StackWalker.getInstance().walk(s -> s.skip(1L).map(StackWalker.StackFrame::getClassName).findFirst().orElseThrow());
        if (!callerClass.startsWith("org.testng.") || callerClass.startsWith("org.testng.reporters.")) {
            return Instrumented.isInstrumented((Class)realClass) ? realClass.getSuperclass() : realClass;
        }
        return realClass;
    }

    private ITestNGMethod[] processMethods(ITestNGMethod[] methods) {
        for (ITestNGMethod method : methods) {
            method.setTestClass((ITestClass)ClassDecorator.decorate(method.getTestClass()));
        }
        return methods;
    }

    public ITestNGMethod[] getAfterClassMethods() {
        return this.processMethods(this.delegate.getAfterClassMethods());
    }

    public ITestNGMethod[] getAfterGroupsMethods() {
        return this.processMethods(this.delegate.getAfterGroupsMethods());
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.processMethods(this.delegate.getAfterSuiteMethods());
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.processMethods(this.delegate.getAfterTestConfigurationMethods());
    }

    public ITestNGMethod[] getAfterTestMethods() {
        return this.processMethods(this.delegate.getAfterTestMethods());
    }

    public ITestNGMethod[] getBeforeClassMethods() {
        return this.processMethods(this.delegate.getBeforeClassMethods());
    }

    public ITestNGMethod[] getBeforeGroupsMethods() {
        return this.processMethods(this.delegate.getBeforeGroupsMethods());
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.processMethods(this.delegate.getBeforeSuiteMethods());
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.processMethods(this.delegate.getBeforeTestConfigurationMethods());
    }

    public ITestNGMethod[] getBeforeTestMethods() {
        return this.processMethods(this.delegate.getBeforeTestMethods());
    }

    public ITestNGMethod[] getTestMethods() {
        return this.processMethods(this.delegate.getTestMethods());
    }

    public void addInstance(Object instance) {
        this.delegate.addInstance(instance);
    }

    public long[] getInstanceHashCodes() {
        return this.delegate.getInstanceHashCodes();
    }

    public Object[] getInstances(boolean create) {
        return this.delegate.getInstances(create);
    }

    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        return this.delegate.getInstances(create, errorMsgPrefix);
    }

    public String getTestName() {
        return this.delegate.getTestName();
    }

    public XmlClass getXmlClass() {
        return this.delegate.getXmlClass();
    }

    public XmlTest getXmlTest() {
        return this.delegate.getXmlTest();
    }
}

