/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.helidon.microprofile.testing.Instrumented;
import org.testng.IModuleFactory;
import org.testng.ITestContext;

public class HelidonTestNgModuleFactory
implements IModuleFactory {
    public Module createModule(ITestContext context, Class<?> testClass) {
        return new ModuleImpl(testClass);
    }

    private static class ModuleImpl<T>
    extends AbstractModule {
        private final Class<T> testClass;
        private final T testInstance;

        ModuleImpl(Class<T> testClass) {
            this.testClass = testClass;
            this.testInstance = Instrumented.allocateInstance(testClass);
        }

        protected void configure() {
            this.bind(this.testClass).toProvider(() -> this.testInstance);
        }
    }
}

