/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import io.helidon.common.UncheckedException;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.microprofile.testing.HelidonTestContainer;
import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.HelidonTestScope;
import io.helidon.microprofile.testing.Instrumented;
import io.helidon.microprofile.testing.Proxies;
import io.helidon.microprofile.testing.testng.ClassContext;
import io.helidon.microprofile.testing.testng.ClassDecorator;
import io.helidon.microprofile.testing.testng.HelidonTest;
import io.helidon.microprofile.testing.testng.HelidonTestDescriptorImpl;
import io.helidon.microprofile.testing.testng.HelidonTestExtensionImpl;
import io.helidon.microprofile.testing.testng.HelidonTestNgListenerBase;
import io.helidon.microprofile.testing.testng.HelidonTestNgModuleFactory;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.testng.IAlterSuiteListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class HelidonTestNgListener
extends HelidonTestNgListenerBase
implements ITestListener,
ISuiteListener,
IAlterSuiteListener,
IMethodInterceptor {
    private static final System.Logger LOGGER = System.getLogger(HelidonTestNgListener.class.getName());
    private static final List<Annotation> TYPE_ANNOTATIONS = List.of(Proxies.annotation(Guice.class, attr -> {
        if (attr.equals("moduleFactory")) {
            return HelidonTestNgModuleFactory.class;
        }
        return null;
    }));
    private static final List<Class<? extends Annotation>> METHOD_EXCLUDES = List.of(BeforeTest.class, BeforeSuite.class);
    private final Map<Class<?>, Context> staticContexts = new ConcurrentHashMap();
    private final Semaphore semaphore = new Semaphore(1);
    private volatile HelidonTestContainer container;

    public void alter(List<XmlSuite> suites) {
        for (XmlSuite suite : suites) {
            for (XmlTest test : suite.getTests()) {
                HashSet xmlClasses = new HashSet(test.getClasses());
                for (XmlPackage xmlPackage : test.getXmlPackages()) {
                    xmlClasses.addAll(xmlPackage.getXmlClasses());
                }
                for (XmlClass xmlClass : xmlClasses) {
                    Class testClass;
                    HelidonTestInfo.ClassInfo classInfo = ClassContext.classInfo(xmlClass.getSupportClass());
                    if (!classInfo.containsAnnotation(HelidonTest.class) || Modifier.isAbstract((testClass = (Class)classInfo.element()).getModifiers())) continue;
                    if (Modifier.isFinal(testClass.getModifiers())) {
                        LOGGER.log(System.Logger.Level.WARNING, "Cannot instrument final class: {0}", testClass.getName());
                        continue;
                    }
                    Context staticContext = this.staticContexts.computeIfAbsent(testClass, this::staticContext);
                    xmlClass.setClass((Class)Contexts.runInContext((Context)staticContext, () -> Instrumented.instrument((Class)testClass, TYPE_ANNOTATIONS, METHOD_EXCLUDES, this::invoke)));
                }
            }
        }
    }

    public void onStart(ISuite suite) {
        for (ITestNGMethod tm : suite.getAllMethods()) {
            if (!Instrumented.isInstrumented((Class)tm.getTestClass().getRealClass())) continue;
            tm.setTestClass(ClassDecorator.decorate(tm.getTestClass()));
        }
    }

    @Override
    boolean filterClass(Class<?> cls) {
        return Instrumented.isInstrumented(cls);
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        LOGGER.log(System.Logger.Level.DEBUG, () -> "intercept - methods: " + methods.stream().map(m -> m.getMethod().getConstructorOrMethod().getMethod()).map(m -> m.getDeclaringClass().getName() + "#" + m.getName()).collect(Collectors.joining(",")));
        ArrayList<IMethodInstance> shared = new ArrayList<IMethodInstance>();
        ArrayList<IMethodInstance> exclusive = new ArrayList<IMethodInstance>();
        for (IMethodInstance e2 : methods) {
            Method method = e2.getMethod().getConstructorOrMethod().getMethod();
            HelidonTestInfo.ClassInfo classInfo = HelidonTestInfo.classInfo(method.getDeclaringClass(), HelidonTestDescriptorImpl::new);
            HelidonTestInfo.MethodInfo methodInfo = HelidonTestInfo.methodInfo((Method)method, (HelidonTestInfo.ClassInfo)classInfo, HelidonTestDescriptorImpl::new);
            if (!classInfo.resetPerTest() && methodInfo.requiresReset()) {
                exclusive.add(e2);
                continue;
            }
            shared.add(e2);
        }
        if (!exclusive.isEmpty()) {
            ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>(shared);
            result.addAll(exclusive);
            result.sort(Comparator.comparingInt(e -> e.getMethod().getPriority()));
            LOGGER.log(System.Logger.Level.DEBUG, () -> "intercept - sorted methods: " + result.stream().map(m -> m.getMethod().getConstructorOrMethod().getMethod()).map(m -> m.getDeclaringClass().getName() + "#" + m.getName()).collect(Collectors.joining(",")));
            return result;
        }
        LOGGER.log(System.Logger.Level.DEBUG, "intercept - methods not modified");
        return methods;
    }

    @Override
    void onBeforeInvocation(ClassContext classContext, HelidonTestInfo.MethodInfo methodInfo, HelidonTestInfo<?> testInfo) {
        LOGGER.log(System.Logger.Level.DEBUG, "onBeforeInvocation: {0}", testInfo.id());
        try {
            if (testInfo.requiresReset()) {
                this.semaphore.acquire();
                classContext.awaitMethods();
                this.closeContainer(testInfo);
                this.initContainer(testInfo);
            } else {
                this.semaphore.acquire();
                this.initContainer((HelidonTestInfo<?>)testInfo.classInfo());
                this.semaphore.release();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void onAfterInvocation(HelidonTestInfo.MethodInfo methodInfo, HelidonTestInfo<?> testInfo, boolean last) {
        LOGGER.log(System.Logger.Level.DEBUG, "onAfterInvocation: {0}", methodInfo.id());
        if (last && testInfo.requiresReset()) {
            this.closeContainer(testInfo);
            this.semaphore.release();
        }
    }

    @Override
    void onBeforeClass(HelidonTestInfo.ClassInfo classInfo) {
        LOGGER.log(System.Logger.Level.DEBUG, "onBeforeClass: {0}", classInfo.id());
    }

    @Override
    void onAfterClass(HelidonTestInfo.ClassInfo classInfo) {
        LOGGER.log(System.Logger.Level.DEBUG, "onAfterClass: {0}", classInfo.id());
        this.closeContainer((HelidonTestInfo<?>)classInfo);
        this.semaphore.drainPermits();
        this.semaphore.release();
    }

    private Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> testClass = proxy.getClass().getSuperclass();
        Context staticContext = this.staticContexts.get(testClass);
        if (staticContext == null) {
            throw new IllegalStateException("Static context not set");
        }
        try {
            return Contexts.runInContext((Context)staticContext, () -> {
                if (this.container == null) {
                    throw new IllegalStateException("Container not set");
                }
                Object instance = this.container.resolveInstance(testClass);
                try {
                    method.setAccessible(true);
                    return method.invoke(instance, args);
                }
                catch (InvocationTargetException e) {
                    throw new UncheckedException((Throwable)e);
                }
            });
        }
        catch (UncheckedException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InvocationTargetException) {
                InvocationTargetException te = (InvocationTargetException)throwable;
                throw te.getCause();
            }
            throw e.getCause();
        }
    }

    private void initContainer(HelidonTestInfo<?> testInfo) {
        if (this.container == null) {
            LOGGER.log(System.Logger.Level.DEBUG, "initContainer: {0}", testInfo.id());
            HelidonTestScope testScope = HelidonTestScope.ofContainer();
            this.container = new HelidonTestContainer(testInfo, testScope, HelidonTestExtensionImpl::new);
        }
    }

    private void closeContainer(HelidonTestInfo<?> testInfo) {
        if (this.container != null) {
            LOGGER.log(System.Logger.Level.DEBUG, "closeContainer: {0}", testInfo.id());
            this.container.close();
            this.container = null;
        }
    }

    private Context staticContext(Class<?> testClass) {
        Context context = Context.builder().id("test-" + testClass.getName() + "-" + System.identityHashCode(testClass)).build();
        context.register((Object)"helidon-registry-static-context", (Object)context);
        context.supply((Object)"helidon-registry", ServiceRegistry.class, () -> ServiceRegistryManager.create().registry());
        return context;
    }
}

