/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.testng;

import io.helidon.config.mp.MpConfigSources;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.testing.testng.AddBean;
import io.helidon.microprofile.testing.testng.AddConfig;
import io.helidon.microprofile.testing.testng.AddConfigBlock;
import io.helidon.microprofile.testing.testng.AddExtension;
import io.helidon.microprofile.testing.testng.AddJaxRs;
import io.helidon.microprofile.testing.testng.Configuration;
import io.helidon.microprofile.testing.testng.DisableDiscovery;
import io.helidon.microprofile.testing.testng.HelidonTest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.ext.cdi1x.internal.ProcessAllAnnotatedTypes;
import org.glassfish.jersey.weld.se.WeldRequestScope;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class HelidonTestNgListener
implements IClassListener,
ITestListener {
    private static final Set<Class<? extends Annotation>> HELIDON_TEST_ANNOTATIONS = Set.of(AddBean.class, AddConfig.class, AddExtension.class, Configuration.class, AddJaxRs.class);
    private static final Map<Class<? extends Annotation>, Annotation> BEAN_DEFINING = new HashMap<Class<? extends Annotation>, Annotation>();
    private List<AddExtension> classLevelExtensions = new ArrayList<AddExtension>();
    private List<AddBean> classLevelBeans = new ArrayList<AddBean>();
    private ConfigMeta classLevelConfigMeta = new ConfigMeta();
    private boolean classLevelDisableDiscovery = false;
    private boolean resetPerTest;
    private Class<?> testClass;
    private ConfigProviderResolver configProviderResolver;
    private Config config;
    private SeContainer container;

    public void onBeforeClass(ITestClass iTestClass) {
        Object[] instances;
        DisableDiscovery discovery;
        this.testClass = iTestClass.getRealClass();
        AddConfig[] configs = (AddConfig[])this.getAnnotations(this.testClass, AddConfig.class);
        this.classLevelConfigMeta.addConfig(configs);
        this.classLevelConfigMeta.configuration(this.testClass.getAnnotation(Configuration.class));
        this.classLevelConfigMeta.addConfigBlock(this.testClass.getAnnotation(AddConfigBlock.class));
        this.configProviderResolver = ConfigProviderResolver.instance();
        AddExtension[] extensions = (AddExtension[])this.getAnnotations(this.testClass, AddExtension.class);
        this.classLevelExtensions.addAll(Arrays.asList(extensions));
        AddBean[] beans = (AddBean[])this.getAnnotations(this.testClass, AddBean.class);
        this.classLevelBeans.addAll(Arrays.asList(beans));
        HelidonTest testAnnot = this.testClass.getAnnotation(HelidonTest.class);
        if (testAnnot != null) {
            this.resetPerTest = testAnnot.resetPerTest();
        }
        if ((discovery = this.testClass.getAnnotation(DisableDiscovery.class)) != null) {
            this.classLevelDisableDiscovery = discovery.value();
        }
        if (this.resetPerTest) {
            this.validatePerTest();
            return;
        }
        this.validatePerClass();
        AddJaxRs addJaxRsAnnotation = this.testClass.getAnnotation(AddJaxRs.class);
        if (addJaxRsAnnotation != null) {
            this.classLevelExtensions.add(ProcessAllAnnotatedTypesLiteral.INSTANCE);
            this.classLevelExtensions.add(ServerCdiExtensionLiteral.INSTANCE);
            this.classLevelExtensions.add(JaxRsCdiExtensionLiteral.INSTANCE);
            this.classLevelExtensions.add(CdiComponentProviderLiteral.INSTANCE);
            this.classLevelBeans.add(WeldRequestScopeLiteral.INSTANCE);
        }
        this.configure(this.classLevelConfigMeta);
        if (!this.classLevelConfigMeta.useExisting) {
            this.startContainer(this.classLevelBeans, this.classLevelExtensions, this.classLevelDisableDiscovery);
        }
        for (Object instance : instances = iTestClass.getInstances(false)) {
            this.injectTestToCdi(instance, iTestClass.getRealClass());
        }
    }

    public void onAfterClass(ITestClass testClass) {
        if (!this.resetPerTest) {
            this.releaseConfig();
            this.stopContainer();
        }
    }

    public void onTestStart(ITestResult result) {
        if (this.resetPerTest) {
            Method method = result.getMethod().getConstructorOrMethod().getMethod();
            AddConfig[] configs = (AddConfig[])method.getAnnotationsByType(AddConfig.class);
            ConfigMeta methodLevelConfigMeta = this.classLevelConfigMeta.nextMethod();
            methodLevelConfigMeta.addConfig(configs);
            methodLevelConfigMeta.configuration(method.getAnnotation(Configuration.class));
            methodLevelConfigMeta.addConfigBlock(method.getAnnotation(AddConfigBlock.class));
            this.configure(methodLevelConfigMeta);
            ArrayList<AddExtension> methodLevelExtensions = new ArrayList<AddExtension>(this.classLevelExtensions);
            ArrayList<AddBean> methodLevelBeans = new ArrayList<AddBean>(this.classLevelBeans);
            boolean methodLevelDisableDiscovery = this.classLevelDisableDiscovery;
            AddExtension[] extensions = (AddExtension[])method.getAnnotationsByType(AddExtension.class);
            methodLevelExtensions.addAll(Arrays.asList(extensions));
            AddBean[] beans = (AddBean[])method.getAnnotationsByType(AddBean.class);
            methodLevelBeans.addAll(Arrays.asList(beans));
            DisableDiscovery discovery = method.getAnnotation(DisableDiscovery.class);
            if (discovery != null) {
                methodLevelDisableDiscovery = discovery.value();
            }
            this.startContainer(methodLevelBeans, methodLevelExtensions, methodLevelDisableDiscovery);
        }
    }

    public void onTestFailure(ITestResult iTestResult) {
        if (this.resetPerTest) {
            this.releaseConfig();
            this.stopContainer();
        }
    }

    public void onTestSuccess(ITestResult iTestResult) {
        if (this.resetPerTest) {
            this.releaseConfig();
            this.stopContainer();
        }
    }

    private <T> void injectTestToCdi(Object bean, Class<T> clazz) {
        BeanManager beanManager = CDI.current().getBeanManager();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        injectionTarget.inject(bean, creationalContext);
    }

    private void validatePerClass() {
        Constructor<?>[] declaredConstructors;
        Method[] methods;
        for (Method method : methods = this.testClass.getMethods()) {
            if (method.getAnnotation(Test.class) == null || !this.hasHelidonTestAnnotation(method)) continue;
            throw new RuntimeException("When a class is annotated with @HelidonTest, there is a single CDI container used to invoke all test methods on the class. Method " + String.valueOf(method) + " has an annotation that modifies container behavior.");
        }
        for (Method method : methods = this.testClass.getDeclaredMethods()) {
            if (method.getAnnotation(Test.class) == null || !this.hasHelidonTestAnnotation(method)) continue;
            throw new RuntimeException("When a class is annotated with @HelidonTest, there is a single CDI container used to invoke all test methods on the class. Method " + String.valueOf(method) + " has an annotation that modifies container behavior.");
        }
        for (Constructor<?> constructor : declaredConstructors = this.testClass.getDeclaredConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null || !this.hasHelidonTestAnnotation(constructor)) continue;
            throw new RuntimeException("When a class is annotated with @HelidonTest, there is a single CDI container used to invoke all test methods on the class. Do not use @Inject annotationover constructor. Use it on each field.");
        }
        AddJaxRs addJaxRsAnnotation = this.testClass.getAnnotation(AddJaxRs.class);
        if (addJaxRsAnnotation != null && this.testClass.getAnnotation(DisableDiscovery.class) == null) {
            throw new RuntimeException("@AddJaxRs annotation should be used only with @DisableDiscovery annotation.");
        }
    }

    private boolean hasHelidonTestAnnotation(AnnotatedElement element) {
        for (Class<? extends Annotation> aClass : HELIDON_TEST_ANNOTATIONS) {
            if (element.getAnnotation(aClass) == null) continue;
            return true;
        }
        return false;
    }

    private void validatePerTest() {
        Field[] fields;
        Constructor<?> c;
        Constructor<?>[] constructors = this.testClass.getConstructors();
        if (constructors.length > 1) {
            throw new RuntimeException("When a class is annotated with @HelidonTest(resetPerTest=true), the class must have only a single no-arg constructor");
        }
        if (constructors.length == 1 && (c = constructors[0]).getParameterCount() > 0) {
            throw new RuntimeException("When a class is annotated with @HelidonTest(resetPerTest=true), the class must have a no-arg constructor");
        }
        for (Field field : fields = this.testClass.getFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            throw new RuntimeException("When a class is annotated with @HelidonTest(resetPerTest=true), injection into fields or constructor is not supported, as each test method uses a different CDI container. Field " + String.valueOf(field) + " is annotated with @Inject");
        }
        for (Field field : fields = this.testClass.getDeclaredFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            throw new RuntimeException("When a class is annotated with @HelidonTest(resetPerTest=true), injection into fields or constructor is not supported, as each test method uses a different CDI container. Field " + String.valueOf(field) + " is annotated with @Inject");
        }
    }

    private void configure(ConfigMeta configMeta) {
        if (this.config != null) {
            this.configProviderResolver.releaseConfig(this.config);
        }
        if (!configMeta.useExisting) {
            ConfigBuilder builder = this.configProviderResolver.getBuilder();
            configMeta.additionalSources.forEach(it -> {
                String fileName = it.trim();
                int idx = fileName.lastIndexOf(46);
                String type = idx > -1 ? fileName.substring(idx + 1) : "properties";
                try {
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(fileName);
                    urls.asIterator().forEachRemaining(url -> builder.withSources(new ConfigSource[]{MpConfigSources.create((String)type, (URL)url)}));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read \"" + fileName + "\" from classpath", e);
                }
            });
            if (configMeta.type != null && configMeta.block != null) {
                builder.withSources(new ConfigSource[]{MpConfigSources.create((String)configMeta.type, (Reader)new StringReader(configMeta.block))});
            }
            this.config = builder.withSources(new ConfigSource[]{MpConfigSources.create(configMeta.additionalKeys)}).addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
            this.configProviderResolver.registerConfig(this.config, Thread.currentThread().getContextClassLoader());
        }
    }

    private void releaseConfig() {
        if (this.configProviderResolver != null && this.config != null) {
            this.configProviderResolver.releaseConfig(this.config);
            this.config = null;
            this.classLevelExtensions = new ArrayList<AddExtension>();
            this.classLevelBeans = new ArrayList<AddBean>();
            this.classLevelConfigMeta = new ConfigMeta();
            this.classLevelDisableDiscovery = false;
            this.configProviderResolver = ConfigProviderResolver.instance();
        }
    }

    private void startContainer(List<AddBean> beanAnnotations, List<AddExtension> extensionAnnotations, boolean disableDiscovery) {
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        if (disableDiscovery) {
            initializer.disableDiscovery();
        }
        initializer.addExtensions(new Extension[]{new AddBeansExtension(this.testClass, beanAnnotations)});
        for (AddExtension addExtension : extensionAnnotations) {
            Class<? extends Extension> extensionClass = addExtension.value();
            if (Modifier.isPublic(extensionClass.getModifiers())) {
                initializer.addExtensions(new Class[]{addExtension.value()});
                continue;
            }
            throw new IllegalArgumentException("Extension classes must be public, but " + extensionClass.getName() + " is not");
        }
        this.container = initializer.initialize();
    }

    private void stopContainer() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
    }

    private <T extends Annotation> T[] getAnnotations(Class<?> testClass, Class<T> annotClass) {
        Annotation[] directAnnotations = testClass.getAnnotationsByType(annotClass);
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(List.of(directAnnotations));
        for (Class<?> superClass = testClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            directAnnotations = superClass.getAnnotationsByType(annotClass);
            allAnnotations.addAll(List.of(directAnnotations));
        }
        Object result = Array.newInstance(annotClass, allAnnotations.size());
        for (int i = 0; i < allAnnotations.size(); ++i) {
            Array.set(result, i, allAnnotations.get(i));
        }
        return (Annotation[])result;
    }

    static {
        BEAN_DEFINING.put(ApplicationScoped.class, (Annotation)ApplicationScoped.Literal.INSTANCE);
        BEAN_DEFINING.put(Singleton.class, (Annotation)ApplicationScoped.Literal.INSTANCE);
        BEAN_DEFINING.put(RequestScoped.class, (Annotation)RequestScoped.Literal.INSTANCE);
        BEAN_DEFINING.put(Dependent.class, (Annotation)Dependent.Literal.INSTANCE);
    }

    private static final class ConfigMeta {
        private final Map<String, String> additionalKeys = new HashMap<String, String>();
        private final List<String> additionalSources = new ArrayList<String>();
        private String type;
        private String block;
        private boolean useExisting;
        private String profile;

        private ConfigMeta() {
            this.additionalKeys.put("mp.initializer.allow", "true");
            this.additionalKeys.put("mp.initializer.no-warn", "true");
            this.additionalKeys.put("server.port", "0");
            this.additionalKeys.putIfAbsent("config_ordinal", "1000");
            this.additionalKeys.put("mp.config.profile", "test");
        }

        private void addConfig(AddConfig[] configs) {
            for (AddConfig config : configs) {
                this.additionalKeys.put(config.key(), config.value());
            }
        }

        private void configuration(Configuration config) {
            if (config == null) {
                return;
            }
            this.useExisting = config.useExisting();
            this.profile = config.profile();
            this.additionalSources.addAll(List.of(config.configSources()));
            this.additionalKeys.put("mp.config.profile", this.profile);
        }

        private void addConfigBlock(AddConfigBlock config) {
            if (config == null) {
                return;
            }
            this.type = config.type();
            this.block = config.value();
        }

        ConfigMeta nextMethod() {
            ConfigMeta methodMeta = new ConfigMeta();
            methodMeta.additionalKeys.putAll(this.additionalKeys);
            methodMeta.additionalSources.addAll(this.additionalSources);
            methodMeta.useExisting = this.useExisting;
            methodMeta.profile = this.profile;
            return methodMeta;
        }
    }

    private static final class ProcessAllAnnotatedTypesLiteral
    extends AnnotationLiteral<AddExtension>
    implements AddExtension {
        static final ProcessAllAnnotatedTypesLiteral INSTANCE = new ProcessAllAnnotatedTypesLiteral();
        private static final long serialVersionUID = 1L;

        private ProcessAllAnnotatedTypesLiteral() {
        }

        @Override
        public Class<? extends Extension> value() {
            return ProcessAllAnnotatedTypes.class;
        }
    }

    private static final class ServerCdiExtensionLiteral
    extends AnnotationLiteral<AddExtension>
    implements AddExtension {
        static final ServerCdiExtensionLiteral INSTANCE = new ServerCdiExtensionLiteral();
        private static final long serialVersionUID = 1L;

        private ServerCdiExtensionLiteral() {
        }

        @Override
        public Class<? extends Extension> value() {
            return ServerCdiExtension.class;
        }
    }

    private static final class JaxRsCdiExtensionLiteral
    extends AnnotationLiteral<AddExtension>
    implements AddExtension {
        static final JaxRsCdiExtensionLiteral INSTANCE = new JaxRsCdiExtensionLiteral();
        private static final long serialVersionUID = 1L;

        private JaxRsCdiExtensionLiteral() {
        }

        @Override
        public Class<? extends Extension> value() {
            return JaxRsCdiExtension.class;
        }
    }

    private static final class CdiComponentProviderLiteral
    extends AnnotationLiteral<AddExtension>
    implements AddExtension {
        static final CdiComponentProviderLiteral INSTANCE = new CdiComponentProviderLiteral();
        private static final long serialVersionUID = 1L;

        private CdiComponentProviderLiteral() {
        }

        @Override
        public Class<? extends Extension> value() {
            return CdiComponentProvider.class;
        }
    }

    private static final class WeldRequestScopeLiteral
    extends AnnotationLiteral<AddBean>
    implements AddBean {
        static final WeldRequestScopeLiteral INSTANCE = new WeldRequestScopeLiteral();
        private static final long serialVersionUID = 1L;

        private WeldRequestScopeLiteral() {
        }

        @Override
        public Class<?> value() {
            return WeldRequestScope.class;
        }

        @Override
        public Class<? extends Annotation> scope() {
            return RequestScoped.class;
        }
    }

    private static class AddBeansExtension
    implements Extension {
        private final Class<?> testClass;
        private final List<AddBean> addBeans;

        private AddBeansExtension(Class<?> testClass, List<AddBean> addBeans) {
            this.testClass = testClass;
            this.addBeans = addBeans;
        }

        void registerOtherBeans(@Observes AfterBeanDiscovery event) {
            Client client = ClientBuilder.newClient();
            event.addBean().addType(WebTarget.class).scope(ApplicationScoped.class).createWith(context -> {
                try {
                    Class<?> extClass = Class.forName("io.helidon.microprofile.server.ServerCdiExtension");
                    Extension extension = CDI.current().getBeanManager().getExtension(extClass);
                    Method m = extension.getClass().getMethod("port", new Class[0]);
                    int port = (Integer)m.invoke((Object)extension, new Object[0]);
                    String uri = "http://localhost:" + port;
                    return client.target(uri);
                }
                catch (ReflectiveOperationException e) {
                    return client.target("http://localhost:7001");
                }
            });
        }

        void registerAddedBeans(@Observes BeforeBeanDiscovery event) {
            event.addAnnotatedType(this.testClass, "testng-" + this.testClass.getName()).add((Annotation)ApplicationScoped.Literal.INSTANCE);
            for (AddBean addBean : this.addBeans) {
                Class<? extends Annotation> definedScope = addBean.scope();
                Annotation scope = BEAN_DEFINING.get(definedScope);
                if (scope == null) {
                    throw new IllegalStateException("Only on of " + String.valueOf(BEAN_DEFINING.keySet()) + " scopes are allowed in tests. Scope " + definedScope.getName() + " is not allowed for bean " + addBean.value().getName());
                }
                AnnotatedTypeConfigurator configurator = event.addAnnotatedType(addBean.value(), "testng-" + addBean.value().getName());
                if (this.hasBda(addBean.value())) continue;
                configurator.add(scope);
            }
        }

        private boolean hasBda(Class<?> value) {
            for (Class<? extends Annotation> aClass : BEAN_DEFINING.keySet()) {
                if (value.getAnnotation(aClass) == null) continue;
                return true;
            }
            return false;
        }
    }
}

