/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.junit5;

import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.HelidonTestScope;
import io.helidon.microprofile.testing.Instrumented;
import io.helidon.microprofile.testing.junit5.HelidonTestContainerImpl;
import io.helidon.microprofile.testing.junit5.HelidonTestDescriptorImpl;
import io.helidon.testing.junit5.TestJunitExtension;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.parallel.ExecutionMode;

public class HelidonJunitExtension
extends TestJunitExtension
implements BeforeEachCallback,
TestInstanceFactory,
InvocationInterceptor,
ParameterResolver {
    private final ReentrantLock lock = new ReentrantLock();

    public Object createTestInstance(TestInstanceFactoryContext fc, ExtensionContext ctx) {
        this.initStaticContext(ctx);
        return this.supplyChecked(ctx, () -> {
            Class testClass = Instrumented.instrument((Class)ctx.getRequiredTestClass(), List.of(), List.of(), (type, method) -> {
                ExtensionContext.Store store = HelidonJunitExtension.store((ExtensionContext)ctx, (AnnotatedElement[])new AnnotatedElement[]{method});
                return HelidonJunitExtension.requiredContainer(store).resolveInstance((Class)type);
            });
            return Instrumented.allocateInstance((Class)testClass);
        });
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(invocation, ic, ctx);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(invocation, ic, ctx);
    }

    public void beforeEach(ExtensionContext context) {
        this.run(context, () -> {
            Method testMethod = context.getRequiredTestMethod();
            Class testClass = context.getRequiredTestClass();
            HelidonTestInfo.ClassInfo classInfo = HelidonTestInfo.classInfo((Class)testClass, HelidonTestDescriptorImpl::new);
            HelidonTestInfo.MethodInfo methodInfo = HelidonTestInfo.methodInfo((Method)testMethod, (HelidonTestInfo.ClassInfo)classInfo, HelidonTestDescriptorImpl::new);
            ExtensionContext classContext = HelidonJunitExtension.classContext(context);
            ExtensionContext.Store classStore = HelidonJunitExtension.store((ExtensionContext)classContext, (AnnotatedElement[])new AnnotatedElement[0]);
            HelidonTestContainerImpl container = HelidonJunitExtension.container(classStore);
            if (context.getExecutionMode() == ExecutionMode.SAME_THREAD && container != null && !container.closed() && methodInfo.requiresReset()) {
                container.close();
            }
            if (container == null || container.closed()) {
                HelidonTestScope scope;
                ExtensionContext.Store methodStore = HelidonJunitExtension.store((ExtensionContext)context, (AnnotatedElement[])new AnnotatedElement[0]);
                TestInstance.Lifecycle lifecycle = context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
                if (lifecycle == TestInstance.Lifecycle.PER_CLASS) {
                    scope = HelidonTestScope.ofContainer();
                } else {
                    scope = HelidonTestScope.ofThread();
                    methodStore.put((Object)"scope", () -> ((HelidonTestScope)scope).close());
                }
                if (methodInfo.requiresReset()) {
                    container = new HelidonTestContainerImpl((HelidonTestInfo<?>)methodInfo, scope);
                    methodStore.put((Object)"container", (Object)container);
                } else {
                    this.lock.lock();
                    try {
                        container = HelidonJunitExtension.container(classStore);
                        if (container == null || container.closed()) {
                            container = new HelidonTestContainerImpl((HelidonTestInfo<?>)classInfo, scope);
                            classStore.put((Object)"container", (Object)container);
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            HelidonJunitExtension.store((ExtensionContext)classContext, (AnnotatedElement[])new AnnotatedElement[]{testMethod}).put((Object)"container", (Object)container);
        });
    }

    public boolean supportsParameter(ParameterContext pc, ExtensionContext ctx) throws ParameterResolutionException {
        return (Boolean)this.supplyChecked(ctx, () -> {
            ExtensionContext.Store store = HelidonJunitExtension.store((ExtensionContext)ctx, (AnnotatedElement[])new AnnotatedElement[]{ctx.getRequiredTestMethod()});
            HelidonTestContainerImpl container = HelidonJunitExtension.requiredContainer(store);
            return !container.initFailed() && container.isSupported(pc.getParameter().getType());
        });
    }

    public Object resolveParameter(ParameterContext pc, ExtensionContext ctx) throws ParameterResolutionException {
        return this.supplyChecked(ctx, () -> {
            ExtensionContext.Store store = HelidonJunitExtension.store((ExtensionContext)ctx, (AnnotatedElement[])new AnnotatedElement[]{ctx.getRequiredTestMethod()});
            HelidonTestContainerImpl container = HelidonJunitExtension.requiredContainer(store);
            return container.initFailed() ? null : container.resolveInstance(pc.getParameter().getType());
        });
    }

    private void invoke(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext context) throws Throwable {
        this.runChecked(context, () -> {
            ExtensionContext.Store methodStore = HelidonJunitExtension.store((ExtensionContext)context, (AnnotatedElement[])new AnnotatedElement[]{context.getRequiredTestMethod()});
            HelidonTestContainerImpl container = HelidonJunitExtension.requiredContainer(methodStore);
            if (container.initFailed()) {
                invocation.skip();
            } else {
                ExtensionContext classContext = HelidonJunitExtension.classContext(context);
                ExtensionContext.Store store = HelidonJunitExtension.store((ExtensionContext)classContext, (AnnotatedElement[])new AnnotatedElement[]{ic.getExecutable()});
                store.put((Object)"container", (Object)container);
                invocation.proceed();
            }
        });
    }

    private static HelidonTestContainerImpl container(ExtensionContext.Store store) {
        return HelidonJunitExtension.storeLookup((ExtensionContext.Store)store, (Object)"container", HelidonTestContainerImpl.class).orElse(null);
    }

    private static HelidonTestContainerImpl requiredContainer(ExtensionContext.Store store) {
        return (HelidonTestContainerImpl)((Object)HelidonJunitExtension.storeLookup((ExtensionContext.Store)store, (Object)"container", HelidonTestContainerImpl.class).orElseThrow(() -> new IllegalStateException("Container not set")));
    }

    private static ExtensionContext classContext(ExtensionContext context) {
        ExtensionContext c = context;
        while (!c.getElement().map(Class.class::isInstance).orElse(false).booleanValue()) {
            c = (ExtensionContext)c.getParent().orElseThrow();
        }
        return c;
    }
}

