/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.inject.hk2.Hk2InjectionManagerFactory;
import org.glassfish.jersey.inject.hk2.ImmediateHk2InjectionManager;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.server.ResourceConfig;

@Priority(value=11)
public class HelidonHK2InjectionManagerFactory
extends Hk2InjectionManagerFactory {
    private static final System.Logger LOGGER = System.getLogger(HelidonHK2InjectionManagerFactory.class.getName());

    public InjectionManager create(Object parent) {
        InjectionManager result;
        if (parent == null) {
            result = super.create(null);
            LOGGER.log(System.Logger.Level.TRACE, () -> "Creating injection manager " + String.valueOf(result));
        } else if (parent instanceof ImmediateHk2InjectionManager) {
            result = (InjectionManager)parent;
            LOGGER.log(System.Logger.Level.TRACE, () -> "Using injection manager for single app case " + String.valueOf(result));
        } else if (parent instanceof InjectionManagerWrapper) {
            InjectionManagerWrapper wrapper = (InjectionManagerWrapper)parent;
            InjectionManager forApplication = super.create(null);
            result = new HelidonInjectionManager(forApplication, wrapper.injectionManager, wrapper.application);
            LOGGER.log(System.Logger.Level.TRACE, () -> "Creating injection manager for multi app case " + String.valueOf(forApplication) + " with shared " + String.valueOf(wrapper.injectionManager));
        } else if (parent instanceof HelidonInjectionManager) {
            result = (InjectionManager)parent;
            LOGGER.log(System.Logger.Level.TRACE, () -> "Re-using existing Helidon injection manager " + String.valueOf(result));
        } else {
            throw new IllegalStateException("Invalid parent injection manager");
        }
        return result;
    }

    static class InjectionManagerWrapper
    implements InjectionManager {
        private final InjectionManager injectionManager;
        private final ResourceConfig application;

        InjectionManagerWrapper(InjectionManager injectionManager, ResourceConfig application) {
            this.injectionManager = injectionManager;
            this.application = application;
        }

        public void completeRegistration() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void shutdown() {
            throw new UnsupportedOperationException("Not supported");
        }

        public boolean isShutdown() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void register(Binding binding) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void register(Iterable<Binding> descriptors) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void register(Binder binder) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void register(Object provider) throws IllegalArgumentException {
            throw new UnsupportedOperationException("Not supported");
        }

        public boolean isRegistrable(Class<?> clazz) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T create(Class<T> createMe) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T createAndInitialize(Class<T> createMe) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T getInstance(Class<T> contractOrImpl) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> T getInstance(Type contractOrImpl) {
            throw new UnsupportedOperationException("Not supported");
        }

        public Object getInstance(ForeignDescriptor foreignDescriptor) {
            throw new UnsupportedOperationException("Not supported");
        }

        public ForeignDescriptor createForeignDescriptor(Binding binding) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> List<T> getAllInstances(Type contractOrImpl) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void inject(Object injectMe) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void inject(Object injectMe, String classAnalyzer) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void preDestroy(Object preDestroyMe) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    static class HelidonInjectionManager
    implements InjectionManager {
        private static final System.Logger LOGGER = System.getLogger(HelidonInjectionManager.class.getName());
        private final ResourceConfig resourceConfig;
        private final InjectionManager shared;
        private final InjectionManager forApplication;

        HelidonInjectionManager(InjectionManager forApplication, InjectionManager shared, ResourceConfig resourceConfig) {
            this.forApplication = forApplication;
            this.shared = shared != null ? shared : forApplication;
            this.resourceConfig = resourceConfig;
        }

        public void completeRegistration() {
            this.shared.completeRegistration();
            this.forApplication.completeRegistration();
        }

        public void shutdown() {
            this.shared.shutdown();
            this.forApplication.shutdown();
        }

        public boolean isShutdown() {
            return this.shared.isShutdown() && this.forApplication.isShutdown();
        }

        public void register(Binding binding) {
            if (this.returnedByApplication(binding)) {
                this.forApplication.register(binding);
                LOGGER.log(System.Logger.Level.TRACE, () -> "register forApplication " + String.valueOf(this.forApplication) + " " + HelidonInjectionManager.toString(binding));
            } else {
                this.shared.register(binding);
                LOGGER.log(System.Logger.Level.TRACE, () -> "register shared " + String.valueOf(this.shared) + " " + HelidonInjectionManager.toString(binding));
            }
        }

        public void register(Iterable<Binding> descriptors) {
            descriptors.forEach(this::register);
        }

        public void register(Binder binder) {
            binder.getBindings().forEach(this::register);
        }

        public void register(Object provider) throws IllegalArgumentException {
            if (this.getSingletons().contains(provider)) {
                this.forApplication.register(provider);
                LOGGER.log(System.Logger.Level.TRACE, () -> "register forApplication " + String.valueOf(this.forApplication) + " " + String.valueOf(provider));
            } else {
                this.shared.register(provider);
                LOGGER.log(System.Logger.Level.TRACE, () -> "register shared " + String.valueOf(this.forApplication) + " " + String.valueOf(provider));
            }
        }

        public boolean isRegistrable(Class<?> clazz) {
            return this.shared.isRegistrable(clazz) || this.forApplication.isRegistrable(clazz);
        }

        public <T> T create(Class<T> createMe) {
            try {
                return (T)this.shared.create(createMe);
            }
            catch (Throwable t) {
                return (T)this.forApplication.create(createMe);
            }
        }

        public <T> T createAndInitialize(Class<T> createMe) {
            try {
                return (T)this.shared.createAndInitialize(createMe);
            }
            catch (Throwable t) {
                return (T)this.forApplication.createAndInitialize(createMe);
            }
        }

        public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
            List sharedList = this.shared.getAllServiceHolders(contractOrImpl, qualifiers);
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                sharedList.forEach(sh -> LOGGER.log(System.Logger.Level.TRACE, "getAllServiceHolders shared " + String.valueOf(this.shared) + " " + String.valueOf(sh.getContractTypes().iterator().next())));
            }
            List forApplicationList = this.forApplication.getAllServiceHolders(contractOrImpl, qualifiers);
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                forApplicationList.forEach(sh -> LOGGER.log(System.Logger.Level.TRACE, "getAllServiceHolders forApplication " + String.valueOf(this.forApplication) + " " + String.valueOf(sh.getContractTypes().iterator().next())));
            }
            ArrayList<ServiceHolder<T>> result = new ArrayList<ServiceHolder<T>>(sharedList);
            result.addAll(forApplicationList);
            return result;
        }

        public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
            Object t = this.shared.getInstance(contractOrImpl, qualifiers);
            return (T)(t != null ? t : this.forApplication.getInstance(contractOrImpl, qualifiers));
        }

        public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
            Object t = this.shared.getInstance(contractOrImpl, classAnalyzer);
            return (T)(t != null ? t : this.forApplication.getInstance(contractOrImpl, classAnalyzer));
        }

        public <T> T getInstance(Class<T> contractOrImpl) {
            Object t = this.shared.getInstance(contractOrImpl);
            return (T)(t != null ? t : this.forApplication.getInstance(contractOrImpl));
        }

        public <T> T getInstance(Type contractOrImpl) {
            Object t = this.shared.getInstance(contractOrImpl);
            return (T)(t != null ? t : this.forApplication.getInstance(contractOrImpl));
        }

        public Object getInstance(ForeignDescriptor foreignDescriptor) {
            Object o = this.shared.getInstance(foreignDescriptor);
            return o != null ? o : this.forApplication.getInstance(foreignDescriptor);
        }

        public ForeignDescriptor createForeignDescriptor(Binding binding) {
            try {
                return this.shared.createForeignDescriptor(binding);
            }
            catch (Throwable t) {
                return this.forApplication.createForeignDescriptor(binding);
            }
        }

        public <T> List<T> getAllInstances(Type contractOrImpl) {
            ArrayList result = new ArrayList();
            result.addAll(this.shared.getAllInstances(contractOrImpl));
            result.addAll(this.forApplication.getAllInstances(contractOrImpl));
            return result;
        }

        public void inject(Object injectMe) {
            try {
                this.shared.inject(injectMe);
            }
            catch (Throwable t) {
                LOGGER.log(System.Logger.Level.WARNING, "Injection failed for " + String.valueOf(injectMe) + " using shared", t);
                this.forApplication.inject(injectMe);
            }
        }

        public void inject(Object injectMe, String classAnalyzer) {
            try {
                this.shared.inject(injectMe, classAnalyzer);
            }
            catch (Throwable t) {
                LOGGER.log(System.Logger.Level.WARNING, "Injection failed for " + String.valueOf(injectMe) + " using shared", t);
                this.forApplication.inject(injectMe, classAnalyzer);
            }
        }

        public void preDestroy(Object preDestroyMe) {
            this.shared.preDestroy(preDestroyMe);
            this.forApplication.preDestroy(preDestroyMe);
        }

        private Set<Class<?>> getClasses() {
            Application application = this.resourceConfig.getApplication();
            return application != null ? this.resourceConfig.getClasses() : Collections.emptySet();
        }

        private Set<Object> getSingletons() {
            Application application = this.resourceConfig.getApplication();
            return application != null ? this.resourceConfig.getSingletons() : Collections.emptySet();
        }

        private static String toString(Binding b) {
            StringBuilder sb = new StringBuilder();
            b.getContracts().forEach(c -> sb.append(" Cont ").append(c));
            if (b.getImplementationType() != null) {
                sb.append("\n\tImpl ").append(b.getImplementationType());
            }
            return sb.toString();
        }

        private boolean returnedByApplication(Binding binding) {
            if (Singleton.class.equals((Object)binding.getScope()) && binding instanceof InstanceBinding) {
                InstanceBinding instanceBinding = (InstanceBinding)binding;
                return this.getSingletons().contains(instanceBinding.getService());
            }
            return binding.getContracts().stream().anyMatch(c -> this.getClasses().contains(c));
        }
    }
}

