/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.microprofile.cdi.HelidonContainer;
import io.helidon.microprofile.server.Server;
import io.helidon.microprofile.server.ServerCdiExtension;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class ServerImpl
implements Server {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private static final Logger STARTUP_LOGGER = Logger.getLogger("io.helidon.microprofile.startup.server");
    private final HelidonContainer helidonContainer = HelidonContainer.instance();
    private final SeContainer container = (SeContainer)CDI.current();
    private final String host;
    private final ServerCdiExtension serverExtension;
    private int port = -1;

    ServerImpl(Server.Builder builder) {
        InetAddress listenHost;
        LOGGER.finest(() -> "Container context id: " + HelidonContainer.instance().context().id());
        if (null == builder.host()) {
            listenHost = InetAddress.getLoopbackAddress();
        } else {
            try {
                listenHost = InetAddress.getByName(builder.host());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed to create address for host: " + builder.host(), e);
            }
        }
        this.host = listenHost.getHostName();
        BeanManager beanManager = this.container.getBeanManager();
        this.serverExtension = (ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class);
        this.serverExtension.context(this.helidonContainer.context());
        this.serverExtension.serverBuilder().port(builder.port()).defaultSocket(it -> it.bindAddress(listenHost));
        this.serverExtension.listenHost(this.host);
    }

    @Override
    public Server start() {
        STARTUP_LOGGER.entering(ServerImpl.class.getName(), "start");
        this.helidonContainer.start();
        STARTUP_LOGGER.finest("Started up");
        this.port = this.serverExtension.port();
        return this;
    }

    @Override
    public Server stop() {
        this.container.close();
        return this;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }
}

