/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.JaxRsService;
import io.helidon.microprofile.server.RoutingConfiguration;
import io.helidon.nima.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.nima.webserver.Routing;
import io.helidon.nima.webserver.WebServer;
import io.helidon.nima.webserver.context.ContextFeature;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRouting;
import io.helidon.nima.webserver.http.HttpService;
import io.helidon.nima.webserver.staticcontent.StaticContentSupport;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;

public class ServerCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(ServerCdiExtension.class.getName());
    private static final Logger STARTUP_LOGGER = Logger.getLogger("io.helidon.microprofile.startup.server");
    private static final AtomicBoolean IN_PROGRESS_OR_RUNNING = new AtomicBoolean();
    private final Map<Bean<?>, RoutingConfiguration> serviceBeans = Collections.synchronizedMap(new IdentityHashMap());
    private WebServer.Builder serverBuilder = WebServer.builder().port(7001);
    private HttpRouting.Builder routingBuilder = HttpRouting.builder();
    private Map<String, HttpRouting.Builder> namedRoutings = new HashMap<String, HttpRouting.Builder>();
    private final List<HttpRouting.Builder> routingsWithKPIMetrics = new ArrayList<HttpRouting.Builder>();
    private String basePath;
    private Config config;
    private WebServer webserver;
    private volatile int port;
    private volatile String listenHost = "0.0.0.0";
    private volatile boolean started;
    private Context context;

    public HttpRouting.Builder routingBuilder(Optional<String> namedRouting, boolean routingNameRequired, String appName) {
        if (namedRouting.isPresent()) {
            String socket = namedRouting.get();
            if (!this.serverBuilder.hasSocket(socket)) {
                if (routingNameRequired) {
                    throw new IllegalStateException("Application " + appName + " requires routing " + socket + " to exist, yet such a socket is not configured for web server");
                }
                LOGGER.info("Routing " + socket + " does not exist, using default routing for application " + appName);
                return this.serverRoutingBuilder();
            }
            return this.serverNamedRoutingBuilder(socket);
        }
        return this.serverRoutingBuilder();
    }

    public WebServer.Builder serverBuilder() {
        return this.serverBuilder;
    }

    public HttpRouting.Builder serverRoutingBuilder() {
        return this.routingBuilder;
    }

    public HttpRouting.Builder serverNamedRoutingBuilder(String name) {
        return this.namedRoutings.computeIfAbsent(name, routeName -> HttpRouting.builder());
    }

    public String host() {
        return this.listenHost;
    }

    public int port() {
        return this.port;
    }

    public int port(String name) {
        return this.webserver.port(name);
    }

    public boolean started() {
        return this.started;
    }

    public void basePath(String basePath) {
        this.basePath = basePath;
    }

    void context(Context context) {
        this.context = context;
    }

    void listenHost(String listenHost) {
        this.listenHost = listenHost;
    }

    private static List<Bean<?>> prioritySort(Set<Bean<?>> beans) {
        ArrayList prioritized = new ArrayList(beans);
        prioritized.sort((o1, o2) -> {
            int firstPriority = ServerCdiExtension.priority(o1.getBeanClass());
            int secondPriority = ServerCdiExtension.priority(o2.getBeanClass());
            return Integer.compare(firstPriority, secondPriority);
        });
        return prioritized;
    }

    private static int priority(Class<?> aClass) {
        Priority prio = aClass.getAnnotation(Priority.class);
        return null == prio ? 5000 : prio.value();
    }

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.serverBuilder.config(config.get("server"));
        this.config = config;
    }

    private void registerKpiMetricsDeferrableRequestHandlers(@Observes @Priority(value=1000) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        JaxRsCdiExtension jaxRs = (JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class);
        List<JaxRsApplication> jaxRsApplications = jaxRs.applicationsToRun();
        jaxRsApplications.forEach(it -> this.registerKpiMetricsDeferrableRequestContextSetterHandler(jaxRs, (JaxRsApplication)it));
    }

    private void recordMethodProducedServices(@Observes ProcessProducerMethod<? extends HttpService, ?> ppm) {
        Method m = ppm.getAnnotatedProducerMethod().getJavaMember();
        String contextKey = m.getDeclaringClass().getName() + "." + m.getName();
        this.serviceBeans.put(ppm.getBean(), new RoutingConfiguration(ppm.getAnnotated(), contextKey));
    }

    private void recordFieldProducedServices(@Observes ProcessProducerField<? extends HttpService, ?> ppf) {
        Field f = ppf.getAnnotatedProducerField().getJavaMember();
        String contextKey = f.getDeclaringClass().getName() + "." + f.getName();
        this.serviceBeans.put(ppf.getBean(), new RoutingConfiguration(ppf.getAnnotated(), contextKey));
    }

    private void recordBeanServices(@Observes ProcessManagedBean<? extends HttpService> pmb) {
        Class cls = pmb.getAnnotatedBeanClass().getJavaClass();
        this.serviceBeans.put(pmb.getBean(), new RoutingConfiguration(pmb.getAnnotated(), cls.getName()));
    }

    private void registerKpiMetricsDeferrableRequestContextSetterHandler(JaxRsCdiExtension jaxRs, JaxRsApplication applicationMeta) {
        boolean routingNameRequired;
        Optional<String> namedRouting = jaxRs.findNamedRouting(this.config, applicationMeta);
        HttpRouting.Builder routing = this.routingBuilder(namedRouting, routingNameRequired = jaxRs.isNamedRoutingRequired(this.config, applicationMeta), applicationMeta.appName());
        if (!this.routingsWithKPIMetrics.contains(routing)) {
            this.routingsWithKPIMetrics.add(routing);
            routing.any(KeyPerformanceIndicatorSupport.DeferrableRequestContext.CONTEXT_SETTING_HANDLER);
            LOGGER.finer(() -> String.format("Adding deferrable request KPI metrics context for routing with name '%s'", namedRouting.orElse("<unnamed>")));
        }
    }

    private void startServer(@Observes @Priority(value=4100) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        if (!IN_PROGRESS_OR_RUNNING.compareAndSet(false, true)) {
            throw new IllegalStateException("There is another builder in progress, or another Server running. You cannot run more than one in parallel");
        }
        this.registerDefaultRedirect();
        this.registerStaticContent();
        this.registerWebServerServices(beanManager);
        this.registerJaxRsApplications(beanManager);
        this.routingBuilder.addFeature((Supplier)ContextFeature.create());
        this.namedRoutings.forEach((name, value) -> value.addFeature((Supplier)ContextFeature.create()));
        this.serverBuilder.routerBuilder("@default").addRouting((Routing)this.routingBuilder.build());
        this.namedRoutings.forEach((name, value) -> this.serverBuilder.routerBuilder(name).addRouting((Routing)value.build()));
        if (this.context == null) {
            this.context = Contexts.context().orElse(Context.builder().id("helidon-mp").build());
        }
        this.webserver = this.serverBuilder.build();
        try {
            this.webserver.start();
            this.started = true;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to start webserver", (Throwable)e);
        }
        this.port = this.webserver.port();
        long initializationElapsedTime = ManagementFactory.getRuntimeMXBean().getUptime();
        String protocol = "http" + (this.webserver.hasTls() ? "s" : "");
        String host = "0.0.0.0".equals(this.listenHost) ? "localhost" : this.listenHost;
        String note = "0.0.0.0".equals(this.listenHost) ? " (and all other host addresses)" : "";
        LOGGER.info(() -> "Server started on " + protocol + "://" + host + ":" + this.port + note + " in " + initializationElapsedTime + " milliseconds (since JVM startup).");
        this.serverBuilder = null;
        this.routingBuilder = null;
        this.namedRoutings = null;
        STARTUP_LOGGER.finest("Server created");
    }

    private void registerJaxRsApplications(BeanManager beanManager) {
        JaxRsCdiExtension jaxRs = (JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class);
        List<JaxRsApplication> jaxRsApplications = jaxRs.applicationsToRun();
        if (jaxRsApplications.isEmpty()) {
            LOGGER.warning("There are no JAX-RS applications or resources. Maybe you forgot META-INF/beans.xml file?");
        } else {
            InjectionManager shared;
            boolean singleManager = this.config.get("server.single-injection-manager").asBoolean().asOptional().orElse(false);
            InjectionManager injectionManager = shared = jaxRsApplications.size() == 1 || singleManager ? null : Injections.createInjectionManager();
            if (shared != null) {
                List instances = jaxRsApplications.stream().flatMap(app -> app.applicationClass().stream()).flatMap(c -> CDI.current().select(c, new Annotation[0]).stream()).toList();
                instances.stream().flatMap(i -> i.getClasses().stream()).filter(ParamConverterProvider.class::isAssignableFrom).forEach(c -> shared.register(Bindings.serviceAsContract((Class)c).to(ParamConverterProvider.class)));
                instances.stream().flatMap(i -> i.getSingletons().stream()).filter(s -> s instanceof ParamConverterProvider).forEach(s -> shared.register((Binding)Bindings.service((Object)s)));
            }
            jaxRsApplications.forEach(it -> this.addApplication(jaxRs, (JaxRsApplication)it, shared));
        }
        STARTUP_LOGGER.finest("Registered jersey application(s)");
    }

    private void registerDefaultRedirect() {
        Optional.ofNullable(this.basePath).or(() -> this.config.get("server.base-path").asString().asOptional()).ifPresent(basePath -> this.routingBuilder.any("/", new Handler[]{(req, res) -> {
            res.status(Http.Status.MOVED_PERMANENTLY_301);
            res.headers().set(Http.Header.LOCATION, new String[]{basePath});
            res.send();
        }}));
        STARTUP_LOGGER.finest("Builders ready");
    }

    private void registerStaticContent() {
        Config config = (Config)ConfigProvider.getConfig();
        config = config.get("server.static");
        config.get("classpath").ifExists(this::registerClasspathStaticContent);
        config.get("path").ifExists(this::registerPathStaticContent);
    }

    private void registerPathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentSupport.FileSystemBuilder pBuilder = StaticContentSupport.builder((Path)((Path)config.get("location").as(Path.class).get()));
        pBuilder.welcomeFileName((String)config.get("welcome").asString().orElse((Object)"index.html"));
        StaticContentSupport staticContent = pBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new Supplier[]{staticContent});
        } else {
            this.routingBuilder.register(new Supplier[]{staticContent});
        }
        STARTUP_LOGGER.finest("Static path");
    }

    private void registerClasspathStaticContent(Config config) {
        Config context = config.get("context");
        StaticContentSupport.ClassPathBuilder cpBuilder = StaticContentSupport.builder((String)((String)config.get("location").asString().get()));
        cpBuilder.welcomeFileName((String)config.get("welcome").asString().orElse((Object)"index.html"));
        config.get("tmp-dir").as(Path.class).ifPresent(arg_0 -> ((StaticContentSupport.ClassPathBuilder)cpBuilder).tmpDir(arg_0));
        config.get("cache-in-memory").asList(String.class).stream().flatMap(Collection::stream).forEach(arg_0 -> ((StaticContentSupport.ClassPathBuilder)cpBuilder).addCacheInMemory(arg_0));
        StaticContentSupport staticContent = cpBuilder.build();
        if (context.exists()) {
            this.routingBuilder.register((String)context.asString().get(), new Supplier[]{staticContent});
        } else {
            this.routingBuilder.register(new Supplier[]{staticContent});
        }
        STARTUP_LOGGER.finest("Static classpath");
    }

    private void stopServer(@Observes @Priority(value=0) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        try {
            if (this.started) {
                this.doStop();
            }
        }
        finally {
            IN_PROGRESS_OR_RUNNING.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        if (null == this.webserver || !this.started) {
            return;
        }
        long beforeT = System.nanoTime();
        try {
            this.webserver.stop();
            this.started = false;
        }
        finally {
            long t = TimeUnit.MILLISECONDS.convert(System.nanoTime() - beforeT, TimeUnit.NANOSECONDS);
            LOGGER.info(() -> "Server stopped in " + t + " milliseconds.");
        }
    }

    private void addApplication(JaxRsCdiExtension jaxRs, JaxRsApplication applicationMeta, InjectionManager injectionManager) {
        LOGGER.info("Registering JAX-RS Application: " + applicationMeta.appName());
        Optional<String> contextRoot = jaxRs.findContextRoot(this.config, applicationMeta);
        Optional<String> namedRouting = jaxRs.findNamedRouting(this.config, applicationMeta);
        boolean routingNameRequired = jaxRs.isNamedRoutingRequired(this.config, applicationMeta);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Application " + applicationMeta.appName() + ", class: " + applicationMeta.appClassName() + ", contextRoot: " + String.valueOf(contextRoot) + ", namedRouting: " + String.valueOf(namedRouting) + ", routingNameRequired: " + routingNameRequired);
        }
        HttpRouting.Builder routing = this.routingBuilder(namedRouting, routingNameRequired, applicationMeta.appName());
        JaxRsService jerseyHandler = jaxRs.toJerseySupport(applicationMeta, injectionManager);
        if (contextRoot.isPresent()) {
            String contextRootString = contextRoot.get();
            LOGGER.fine(() -> "JAX-RS application " + applicationMeta.appName() + " registered on '" + contextRootString + "'");
            if (contextRootString.endsWith("/")) {
                routing.register(contextRootString.substring(0, contextRootString.length() - 1), new Supplier[]{jerseyHandler});
            } else {
                routing.register(contextRootString, new Supplier[]{jerseyHandler});
            }
        } else {
            LOGGER.fine(() -> "JAX-RS application " + applicationMeta.appName() + " registered on '/'");
            routing.register(new Supplier[]{jerseyHandler});
        }
    }

    private void registerWebServerServices(BeanManager beanManager) {
        List<Bean<?>> beans = ServerCdiExtension.prioritySort(beanManager.getBeans(HttpService.class, new Annotation[0]));
        CreationalContext context = beanManager.createCreationalContext(null);
        Iterator<Bean<?>> iterator = beans.iterator();
        while (iterator.hasNext()) {
            Bean<?> bean;
            Bean<?> objBean = bean = iterator.next();
            HttpService service = (HttpService)objBean.create(context);
            this.registerWebServerService(this.serviceBeans.remove(bean), service);
        }
        STARTUP_LOGGER.finest("Registered WebServer services");
    }

    private void registerWebServerService(RoutingConfiguration routingConf, HttpService service) {
        String path = routingConf.routingPath(this.config);
        String routingName = routingConf.routingName(this.config);
        boolean routingNameRequired = routingConf.required(this.config);
        HttpRouting.Builder routing = this.findRouting(routingConf.configContext(), routingName, routingNameRequired);
        if (null == path || "/".equals(path)) {
            routing.register(new Supplier[]{service});
        } else {
            routing.register(path, new Supplier[]{service});
        }
    }

    private HttpRouting.Builder findRouting(String className, String routingName, boolean routingNameRequired) {
        if (null == routingName || "@default".equals(routingName)) {
            return this.serverRoutingBuilder();
        }
        if (!this.serverBuilder.hasSocket(routingName)) {
            if (routingNameRequired) {
                throw new IllegalStateException(className + " requires routing " + routingName + ", yet such a named socket is not configured for web server");
            }
            LOGGER.fine(() -> className + " is configured with named routing " + routingName + ". Such a routing is not configured, this service/application will run on default socket.");
            return this.serverRoutingBuilder();
        }
        return this.serverNamedRoutingBuilder(routingName);
    }
}

