/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.config.Config;
import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import jakarta.enterprise.inject.spi.Annotated;

class RoutingConfiguration {
    private String routingName = "@default";
    private String routingPath = null;
    private boolean required = false;
    private final String contextConfigKey;

    RoutingConfiguration(Annotated annotated, String contextConfigKey) {
        RoutingName rn = (RoutingName)annotated.getAnnotation(RoutingName.class);
        RoutingPath rp = (RoutingPath)annotated.getAnnotation(RoutingPath.class);
        this.contextConfigKey = contextConfigKey;
        if (rn != null) {
            this.routingName = rn.value();
            this.required = rn.required();
        }
        if (rp != null) {
            this.routingPath = rp.value();
        }
    }

    String routingName(Config config) {
        return (String)config.get(this.contextConfigKey).get("routing-name.name").asString().orElse((Object)this.routingName);
    }

    String routingPath(Config config) {
        return (String)config.get(this.contextConfigKey).get("routing-path.path").asString().orElse((Object)this.routingPath);
    }

    boolean required(Config config) {
        return (Boolean)config.get(this.contextConfigKey).get("routing-name.required").asBoolean().orElse((Object)this.required);
    }

    String configContext() {
        return this.contextConfigKey;
    }
}

