/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.config.Config;
import io.helidon.microprofile.server.RoutingBuildersImpl;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.webserver.Routing;
import java.util.Optional;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.ConfigProvider;

public interface RoutingBuilders {
    public Routing.Builder defaultRoutingBuilder();

    public Routing.Builder routingBuilder();

    public static RoutingBuilders create(String componentName) {
        return RoutingBuilders.create(((Config)ConfigProvider.getConfig()).get(componentName));
    }

    public static RoutingBuilders create(Config componentConfig) {
        ServerCdiExtension extension = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
        Routing.Builder defaultRoutingBuilder = extension.serverRoutingBuilder();
        Routing.Builder actualRoutingBuilder = componentConfig.get("routing").asString().flatMap(routeName -> {
            if ("@default".equals(routeName)) {
                return Optional.empty();
            }
            return Optional.of(routeName);
        }).map(extension::serverNamedRoutingBuilder).orElse(defaultRoutingBuilder);
        return new RoutingBuildersImpl(defaultRoutingBuilder, actualRoutingBuilder);
    }
}

