/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.config.Config;
import io.helidon.microprofile.server.RoutingBuildersImpl;
import io.helidon.microprofile.server.spi.MpServiceContext;
import io.helidon.webserver.Routing;
import java.util.Optional;

public interface RoutingBuilders {
    public Routing.Builder defaultRoutingBuilder();

    public Routing.Builder routingBuilder();

    public static RoutingBuilders create(MpServiceContext context, String componentName) {
        return RoutingBuilders.create(context, context.helidonConfig().get(componentName));
    }

    public static RoutingBuilders create(MpServiceContext context, Config componentConfig) {
        Routing.Builder defaultRoutingBuilder = context.serverRoutingBuilder();
        Routing.Builder actualRoutingBuilder = componentConfig.get("routing").asString().flatMap(routeName -> {
            if ("@default".equals(routeName)) {
                return Optional.empty();
            }
            return Optional.of(routeName);
        }).map(context::serverNamedRoutingBuilder).orElse(defaultRoutingBuilder);
        return new RoutingBuildersImpl(defaultRoutingBuilder, actualRoutingBuilder);
    }
}

