/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.microprofile.server.RoutingName;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;

public final class JaxRsApplication {
    private final String contextRoot;
    private final ResourceConfig config;
    private final ExecutorService executorService;
    private final String appClassName;
    private final String routingName;
    private final boolean routingNameRequired;

    public static JaxRsApplication create(Class<? extends Application> application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static JaxRsApplication create(Application application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private JaxRsApplication(Builder builder) {
        this.contextRoot = builder.contextRoot;
        this.config = builder.config;
        this.executorService = builder.executorService;
        this.appClassName = builder.appClassName;
        this.routingName = builder.routingName;
        this.routingNameRequired = builder.routingNameRequired;
    }

    String contextRoot() {
        return this.contextRoot;
    }

    ResourceConfig resourceConfig() {
        return this.config;
    }

    Optional<ExecutorService> executorService() {
        return Optional.ofNullable(this.executorService);
    }

    String appClassName() {
        return this.appClassName;
    }

    String routingName() {
        return this.routingName;
    }

    boolean routingNameRequired() {
        return this.routingNameRequired;
    }

    public static class Builder {
        private static final String DEFAULT_CONTEXT_ROOT = "/";
        private String contextRoot;
        private ResourceConfig config;
        private ExecutorService executorService;
        private String appClassName;
        private String routingName;
        private boolean routingNameRequired;

        public Builder contextRoot(String contextRoot) {
            this.contextRoot = Builder.normalize(contextRoot);
            return this;
        }

        public Builder config(ResourceConfig config) {
            this.config = config;
            return this;
        }

        public Builder application(Application app) {
            this.config = Builder.toConfig(app);
            Class<?> clazz = app.getClass();
            this.contextRoot(clazz);
            this.routingName(clazz);
            this.appClassName = clazz.getName();
            return this;
        }

        public Builder application(Class<? extends Application> appClass) {
            this.config = ResourceConfig.forApplicationClass(appClass);
            this.contextRoot(appClass);
            this.routingName(appClass);
            this.appClassName = appClass.getName();
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public JaxRsApplication build() {
            if (null == this.contextRoot) {
                this.contextRoot = DEFAULT_CONTEXT_ROOT;
            }
            return new JaxRsApplication(this);
        }

        private static ResourceConfig toConfig(Application application) {
            if (application instanceof ResourceConfig) {
                return (ResourceConfig)application;
            }
            return ResourceConfig.forApplication((Application)application);
        }

        private void contextRoot(Class<?> clazz) {
            if (null != this.contextRoot) {
                return;
            }
            ApplicationPath path = clazz.getAnnotation(ApplicationPath.class);
            if (null != path) {
                this.contextRoot = Builder.normalize(path.value());
            }
        }

        private static String normalize(String contextRoot) {
            int length = contextRoot.length();
            return length > 1 && contextRoot.endsWith(DEFAULT_CONTEXT_ROOT) ? contextRoot.substring(0, length - 1) : contextRoot;
        }

        private void routingName(Class<?> clazz) {
            if (null != this.routingName) {
                return;
            }
            RoutingName rn = clazz.getAnnotation(RoutingName.class);
            if (null != rn) {
                this.routingName = rn.value();
                this.routingNameRequired = rn.required();
            }
        }
    }
}

