/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.microprofile.config.MpConfig;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.MpException;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.server.ServerImpl;
import io.helidon.microprofile.server.spi.MpService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.glassfish.jersey.server.ResourceConfig;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

public interface Server {
    @SafeVarargs
    public static Server create(Application ... applications) throws MpException {
        Builder builder = Server.builder();
        Arrays.stream(applications).forEach(builder::addApplication);
        return builder.build();
    }

    @SafeVarargs
    public static Server create(Class<? extends Application> ... applicationClasses) throws MpException {
        Builder builder = Server.builder();
        Arrays.stream(applicationClasses).forEach(builder::addApplication);
        return builder.build();
    }

    public static Server create() throws MpException {
        return Server.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public SeContainer cdiContainer();

    public Server start() throws MpException;

    public Server stop() throws MpException;

    public String host();

    public int port();

    public static final class Builder {
        private static final AtomicInteger MP_SERVER_COUNTER = new AtomicInteger(1);
        private static final Logger LOGGER = Logger.getLogger(Builder.class.getName());
        private static final Logger STARTUP_LOGGER = Logger.getLogger("io.helidon.microprofile.startup.builder");
        private final List<Class<?>> resourceClasses = new LinkedList();
        private final List<JaxRsApplication> applications = new LinkedList<JaxRsApplication>();
        private HelidonServiceLoader.Builder<MpService> extensionBuilder = HelidonServiceLoader.builder(ServiceLoader.load(MpService.class));
        private ResourceConfig resourceConfig;
        private SeContainer cdiContainer;
        private MpConfig config;
        private String host;
        private String basePath;
        private int port = -1;
        private boolean containerCreated;
        private Supplier<? extends ExecutorService> defaultExecutorService;
        private Context parentContext;
        private Context serverContext;
        private Boolean supportParallelRun;

        private Builder() {
        }

        private static ResourceConfig configForResourceClasses(final List<Class<?>> resourceClasses) {
            return ResourceConfig.forApplication((Application)new Application(){

                public Set<Class<?>> getClasses() {
                    return new HashSet(resourceClasses);
                }
            });
        }

        public Server build() {
            this.serverContext = null == this.parentContext ? Context.builder().id("mp-" + MP_SERVER_COUNTER.getAndIncrement()).build() : Context.builder().parent(this.parentContext).id(this.parentContext.id() + ":mp-" + MP_SERVER_COUNTER.getAndIncrement()).build();
            return (Server)Contexts.runInContext((Context)this.serverContext, this::doBuild);
        }

        private Server doBuild() {
            STARTUP_LOGGER.entering(Builder.class.getName(), "build");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == this.config) {
                this.config = (MpConfig)ConfigProviderResolver.instance().getConfig(classLoader);
            } else {
                ConfigProviderResolver.instance().registerConfig((org.eclipse.microprofile.config.Config)this.config, classLoader);
            }
            if (null == this.defaultExecutorService) {
                this.defaultExecutorService = ServerThreadPoolSupplier.builder().name("server").config(this.config.helidonConfig().get("server.executor-service")).build();
            }
            STARTUP_LOGGER.finest("Configuration obtained");
            if (null == this.cdiContainer) {
                this.cdiContainer = this.currentContainer().orElseGet(() -> {
                    this.containerCreated = true;
                    return this.createContainer(classLoader);
                });
            }
            STARTUP_LOGGER.finest("CDI Container obtained");
            if (this.applications.isEmpty()) {
                if (!this.resourceClasses.isEmpty()) {
                    this.resourceConfig = Builder.configForResourceClasses(this.resourceClasses);
                }
                if (null == this.resourceConfig) {
                    this.resourcesFromContainer();
                }
                if (null != this.resourceConfig) {
                    this.applications.add(JaxRsApplication.create((Application)this.resourceConfig));
                }
            } else if (!this.resourceClasses.isEmpty()) {
                this.applications.add(JaxRsApplication.create((Application)Builder.configForResourceClasses(this.resourceClasses)));
            }
            STARTUP_LOGGER.finest("Jersey resource configuration");
            if (null == this.host) {
                this.host = this.config.getOptionalValue("server.host", String.class).orElse("0.0.0.0");
            }
            if (this.port == -1) {
                this.port = this.config.getOptionalValue("server.port", Integer.class).orElse(7001);
            }
            if (null == this.supportParallelRun) {
                this.supportParallelRun = this.config.getOptionalValue("server.support-parallel", Boolean.class).orElse(false);
            }
            return new ServerImpl(this);
        }

        private void resourcesFromContainer() {
            ServerCdiExtension extension = (ServerCdiExtension)this.cdiContainer.getBeanManager().getExtension(ServerCdiExtension.class);
            if (null == extension) {
                throw new RuntimeException("Failed to find JAX-RS resource to use, extension not registered with container");
            }
            List<Class<? extends Application>> applications = extension.getApplications();
            if (applications.isEmpty()) {
                List<Class<?>> resourceClasses = extension.getResourceClasses();
                if (resourceClasses.isEmpty()) {
                    LOGGER.warning("Failed to find JAX-RS resource to use");
                }
                this.resourceConfig = Builder.configForResourceClasses(resourceClasses);
            } else {
                applications.forEach(this::addApplication);
            }
        }

        private Optional<SeContainer> currentContainer() {
            try {
                CDI current = CDI.current();
                STARTUP_LOGGER.finest("CDI.current()");
                if (null == current) {
                    return Optional.empty();
                }
                if (current instanceof SeContainer) {
                    SeContainer currentSe = (SeContainer)current;
                    if (currentSe.isRunning()) {
                        return Optional.of(currentSe);
                    }
                    return Optional.empty();
                }
                throw new MpException("Running in a non-SE CDI Container: " + current.getClass().getName());
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }

        private SeContainer createContainer(ClassLoader classLoader) {
            Weld initializer = new Weld();
            initializer.addBeanDefiningAnnotations(new Class[]{Path.class});
            initializer.setClassLoader(classLoader);
            HashMap props = new HashMap((Map)this.config.helidonConfig().get("cdi").detach().asMap().orElse((Object)CollectionsHelper.mapOf()));
            initializer.setProperties(props);
            this.resourceClasses.stream().filter(this::notACdiBean).forEach(xva$0 -> initializer.addBeanClasses(new Class[]{xva$0}));
            STARTUP_LOGGER.finest("Initializer");
            WeldContainer container = initializer.initialize();
            STARTUP_LOGGER.finest("Initalizer.initialize()");
            return container;
        }

        private boolean notACdiBean(Class<?> clazz) {
            if (clazz.getAnnotation(RequestScoped.class) != null) {
                return false;
            }
            return clazz.getAnnotation(ApplicationScoped.class) == null;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder extensionsService(HelidonServiceLoader.Builder<MpService> loaderBuilder) {
            this.extensionBuilder = loaderBuilder;
            return this;
        }

        public Builder addExtension(MpService service) {
            this.extensionBuilder.addService((Object)service);
            return this;
        }

        public Builder defaultExecutorServiceSupplier(Supplier<? extends ExecutorService> supplier) {
            this.defaultExecutorService = supplier;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder config(Config config) {
            this.config = (MpConfig)MpConfig.builder().config(config).build();
            return this;
        }

        public Builder config(org.eclipse.microprofile.config.Config config) {
            this.config = (MpConfig)config;
            return this;
        }

        public Builder cdiContainer(SeContainer cdiContainer) {
            this.cdiContainer = cdiContainer;
            return this;
        }

        public Builder resourceConfig(ResourceConfig config) {
            this.resourceConfig = config;
            return this;
        }

        public Builder addApplication(JaxRsApplication application) {
            this.applications.add(application);
            return this;
        }

        public Builder addApplication(Application application) {
            this.applications.add(JaxRsApplication.create(application));
            return this;
        }

        public Builder addApplication(String contextRoot, Application application) {
            this.applications.add(JaxRsApplication.builder().application(application).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addApplication(Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.create(applicationClass));
            return this;
        }

        public Builder addApplication(String contextRoot, Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.builder().application(applicationClass).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addResourceClass(Class<?> resource) {
            this.resourceClasses.add(resource);
            return this;
        }

        public Builder context(Context parentContext) {
            this.parentContext = parentContext;
            return this;
        }

        public Builder supportParallel(boolean supportParallelRun) {
            this.supportParallelRun = supportParallelRun;
            return this;
        }

        List<JaxRsApplication> applications() {
            return new LinkedList<JaxRsApplication>(this.applications);
        }

        SeContainer cdiContainer() {
            return this.cdiContainer;
        }

        org.eclipse.microprofile.config.Config config() {
            return this.config;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }

        List<MpService> extensions() {
            return this.extensionBuilder.build().asList();
        }

        boolean containerCreated() {
            return this.containerCreated;
        }

        ExecutorService defaultExecutorService() {
            return this.defaultExecutorService.get();
        }

        String basePath() {
            return this.basePath;
        }

        Context context() {
            return this.serverContext;
        }

        boolean supportParallelRun() {
            return this.supportParallelRun;
        }
    }
}

