/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;

public final class JaxRsApplication {
    private final String contextRoot;
    private final ResourceConfig config;
    private final ExecutorService executorService;

    public static JaxRsApplication create(Class<? extends Application> application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static JaxRsApplication create(Application application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private JaxRsApplication(String contextRoot, ResourceConfig config, ExecutorService executorService) {
        this.contextRoot = contextRoot;
        this.config = config;
        this.executorService = executorService;
    }

    String getContextRoot() {
        return this.contextRoot;
    }

    ResourceConfig getConfig() {
        return this.config;
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    public static class Builder {
        private static final String DEFAULT_CONTEXT_ROOT = "/";
        private String contextRoot;
        private ResourceConfig config;
        private ExecutorService executorService;

        public Builder contextRoot(String contextRoot) {
            this.contextRoot = contextRoot;
            return this;
        }

        public Builder config(ResourceConfig config) {
            this.config = config;
            return this;
        }

        public Builder application(Application app) {
            this.config = Builder.toConfig(app);
            if (null == this.contextRoot) {
                this.contextRoot = Builder.getContextRoot(app.getClass());
            }
            return this;
        }

        public Builder application(Class<? extends Application> appClass) {
            this.config = ResourceConfig.forApplicationClass(appClass);
            if (null == this.contextRoot) {
                this.contextRoot = Builder.getContextRoot(appClass);
            }
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public JaxRsApplication build() {
            if (null == this.contextRoot) {
                this.contextRoot = DEFAULT_CONTEXT_ROOT;
            }
            return new JaxRsApplication(this.contextRoot, this.config, this.executorService);
        }

        private static ResourceConfig toConfig(Application application) {
            if (application instanceof ResourceConfig) {
                return (ResourceConfig)application;
            }
            return ResourceConfig.forApplication((Application)application);
        }

        private static String getContextRoot(Class<? extends Application> application) {
            ApplicationPath path = application.getAnnotation(ApplicationPath.class);
            if (null == path) {
                return null;
            }
            return path.value();
        }
    }
}

