/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.scheduling;

import io.helidon.common.configurable.ScheduledThreadPoolConfig;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.config.DeprecatedConfig;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.scheduling.FixedRate;
import io.helidon.microprofile.scheduling.Scheduled;
import io.helidon.scheduling.Cron;
import io.helidon.scheduling.CronConfig;
import io.helidon.scheduling.FixedRateConfig;
import io.helidon.scheduling.Invocation;
import io.helidon.scheduling.Scheduling;
import io.helidon.scheduling.Task;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class SchedulingCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(SchedulingCdiExtension.class.getName());
    private final Queue<AnnotatedMethod<?>> methods = new LinkedList();
    private final Map<AnnotatedMethod<?>, Bean<?>> beans = new HashMap();
    private final Queue<ScheduledExecutorService> executors = new LinkedList<ScheduledExecutorService>();
    private Config config;
    private Config schedulingConfig;

    void registerMethods(@Observes @WithAnnotations(value={Scheduled.class, FixedRate.class, Scheduling.Cron.class, Scheduling.FixedRate.class}) ProcessAnnotatedType<?> pat) {
        pat.getAnnotatedType().getMethods().stream().filter(this::hasScheduleAnnotation).forEach(this.methods::add);
    }

    void onProcessBean(@Observes ProcessManagedBean<?> event) {
        Bean bean = event.getBean();
        Class beanClass = bean.getBeanClass();
        for (AnnotatedMethod annotatedMethod : this.methods) {
            if (beanClass != annotatedMethod.getDeclaringType().getJavaClass()) continue;
            this.beans.put(annotatedMethod, bean);
        }
    }

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.config = config;
        this.schedulingConfig = config.get("schedule");
    }

    void invoke(@Observes @Priority(value=8000) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        ScheduledThreadPoolConfig.Builder scheduledThreadPoolbuilder = (ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().config(this.schedulingConfig);
        if (scheduledThreadPoolbuilder.threadNamePrefix().isEmpty()) {
            scheduledThreadPoolbuilder.threadNamePrefix("scheduled-");
        }
        ScheduledExecutorService executorService = scheduledThreadPoolbuilder.build().get();
        this.executors.add(executorService);
        for (AnnotatedMethod annotatedMethod : this.methods) {
            io.helidon.scheduling.FixedRate task;
            Annotation annotation;
            Class aClass = annotatedMethod.getDeclaringType().getJavaClass();
            Bean<?> bean = this.beans.get(annotatedMethod);
            Object beanInstance = SchedulingCdiExtension.lookup(bean, beanManager);
            Method method = annotatedMethod.getJavaMember();
            if (!method.trySetAccessible()) {
                throw new DeploymentException(String.format("Scheduled method %s#%s is not accessible!", method.getDeclaringClass().getName(), method.getName()));
            }
            if (annotatedMethod.isAnnotationPresent(FixedRate.class) && annotatedMethod.isAnnotationPresent(Scheduled.class)) {
                throw new DeploymentException(String.format("Scheduled method %s#%s can have only one scheduling annotation.", method.getDeclaringClass().getName(), method.getName()));
            }
            Config methodConfig = this.config.get(aClass.getName() + "." + method.getName() + ".schedule");
            if (annotatedMethod.isAnnotationPresent(FixedRate.class)) {
                annotation = (FixedRate)annotatedMethod.getAnnotation(FixedRate.class);
                task = ((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)io.helidon.scheduling.FixedRate.builder().initialDelay(annotation.initialDelay())).delayType(annotation.delayType())).delay(annotation.value())).timeUnit(annotation.timeUnit())).config(methodConfig)).executor(executorService)).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv))).build();
                LOGGER.log(System.Logger.Level.DEBUG, () -> SchedulingCdiExtension.lambda$invoke$1(aClass, method, (Task)task));
                continue;
            }
            if (annotatedMethod.isAnnotationPresent(Scheduling.FixedRate.class)) {
                annotation = (Scheduling.FixedRate)annotatedMethod.getAnnotation(Scheduling.FixedRate.class);
                task = ((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)((FixedRateConfig.Builder)io.helidon.scheduling.FixedRate.builder().delayBy(Duration.parse(ConfigBuilderSupport.resolveExpression((Config)this.config, (String)annotation.delayBy())))).delayType(annotation.delayType())).interval(Duration.parse(ConfigBuilderSupport.resolveExpression((Config)this.config, (String)annotation.value())))).executor(executorService)).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv))).build();
                LOGGER.log(System.Logger.Level.DEBUG, () -> SchedulingCdiExtension.lambda$invoke$3(aClass, method, (Task)task));
                continue;
            }
            if (annotatedMethod.isAnnotationPresent(Scheduled.class)) {
                annotation = (Scheduled)annotatedMethod.getAnnotation(Scheduled.class);
                task = ((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)Cron.builder().concurrentExecution(annotation.concurrentExecution())).expression((String)DeprecatedConfig.get((Config)methodConfig, (String)"expression", (String)"cron").asString().orElseGet(() -> this.lambda$invoke$4((Scheduled)annotation)))).config(methodConfig)).executor(executorService)).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv))).build();
                LOGGER.log(System.Logger.Level.DEBUG, () -> SchedulingCdiExtension.lambda$invoke$6(aClass, method, (Task)task));
                continue;
            }
            if (!annotatedMethod.isAnnotationPresent(Scheduling.Cron.class)) continue;
            annotation = (Scheduling.Cron)annotatedMethod.getAnnotation(Scheduling.Cron.class);
            task = ((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)((CronConfig.Builder)Cron.builder().concurrentExecution(annotation.concurrent())).expression(ConfigBuilderSupport.resolveExpression((Config)this.config, (String)annotation.value()))).executor(executorService)).task(inv -> SchedulingCdiExtension.invokeWithOptionalParam(beanInstance, method, inv))).build();
            LOGGER.log(System.Logger.Level.DEBUG, () -> SchedulingCdiExtension.lambda$invoke$8(aClass, method, (Task)task));
        }
    }

    void terminate(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.executors.forEach(ExecutorService::shutdownNow);
    }

    static <T> T lookup(Bean<?> bean, BeanManager beanManager) {
        Context context = beanManager.getContext(bean.getScope());
        Object instance = context.get(bean);
        if (instance == null) {
            CreationalContext creationalContext = beanManager.createCreationalContext(bean);
            instance = beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
        }
        if (instance == null) {
            throw new DeploymentException("Instance of bean " + bean.getName() + " not found");
        }
        return (T)instance;
    }

    static void invokeWithOptionalParam(Object instance, Method method, Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class invClazz = invocation.getClass();
        if (parameterTypes.length > 1 || parameterTypes.length > 0 && !parameterTypes[0].isAssignableFrom(invClazz)) {
            throw new DeploymentException(String.format("Unsupported param types for scheduled method %s, none or %s is supported.", method.getName(), invClazz.getName()));
        }
        if (parameterTypes.length == 0) {
            method.invoke(instance, new Object[0]);
        } else {
            method.invoke(instance, invocation);
        }
    }

    private boolean hasScheduleAnnotation(AnnotatedMethod<?> am) {
        return am.isAnnotationPresent(Scheduled.class) || am.isAnnotationPresent(FixedRate.class) || am.isAnnotationPresent(Scheduling.Cron.class) || am.isAnnotationPresent(Scheduling.FixedRate.class);
    }

    private static /* synthetic */ String lambda$invoke$8(Class aClass, Method method, Task task) {
        return String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description());
    }

    private static /* synthetic */ String lambda$invoke$6(Class aClass, Method method, Task task) {
        return String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description());
    }

    private /* synthetic */ String lambda$invoke$4(Scheduled annotation) {
        return ConfigBuilderSupport.resolveExpression((Config)this.config, (String)annotation.value());
    }

    private static /* synthetic */ String lambda$invoke$3(Class aClass, Method method, Task task) {
        return String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description());
    }

    private static /* synthetic */ String lambda$invoke$1(Class aClass, Method method, Task task) {
        return String.format("Method %s#%s scheduled to be executed %s", aClass.getSimpleName(), method.getName(), task.description());
    }
}

