/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.openapi.FilteredIndexViewsBuilder;
import io.helidon.microprofile.openapi.JsonpAnnotationScannerExtension;
import io.helidon.microprofile.openapi.MpOpenApiManagerConfig;
import io.helidon.microprofile.openapi.OpenApiCdiExtension;
import io.helidon.microprofile.openapi.OpenApiHelper;
import io.helidon.microprofile.openapi.OpenApiParser;
import io.helidon.microprofile.openapi.OpenApiSerializer;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.openapi.OpenApiFormat;
import io.helidon.openapi.OpenApiManager;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

final class MpOpenApiManager
implements OpenApiManager<OpenAPI> {
    private static final System.Logger LOGGER = System.getLogger(MpOpenApiManager.class.getName());
    private static final String CONFIG_EXT_PREFIX = "mp.openapi.extensions.helidon.";
    static final String USE_JAXRS_SEMANTICS_KEY = "mp.openapi.extensions.helidon.use-jaxrs-semantics";
    private final Config config;
    private final MpOpenApiManagerConfig managerConfig;
    private final OpenApiConfig openApiConfig;
    private final List<AnnotationScannerExtension> scannerExtensions = List.of(new JsonpAnnotationScannerExtension());
    private final LazyValue<List<FilteredIndexView>> filteredIndexViews = LazyValue.create(this::buildFilteredIndexViews);

    MpOpenApiManager(Config config) {
        this.config = config;
        this.managerConfig = ((MpOpenApiManagerConfig.Builder)MpOpenApiManagerConfig.builder().update(builder -> config.getOptionalValue(USE_JAXRS_SEMANTICS_KEY, Boolean.class).ifPresent(builder::useJaxRsSemantics))).build();
        this.openApiConfig = new OpenApiConfigImpl(config);
    }

    public String name() {
        return "manager";
    }

    public String type() {
        return "mp";
    }

    public OpenAPI load(String content) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        OpenApiDocument.INSTANCE.reset();
        OpenApiDocument.INSTANCE.config(this.openApiConfig);
        OpenApiDocument.INSTANCE.modelFromReader(OpenApiProcessor.modelFromReader((OpenApiConfig)this.openApiConfig, (ClassLoader)contextClassLoader));
        if (!content.isBlank()) {
            OpenAPI document = OpenApiParser.parse(OpenApiHelper.types(), OpenAPI.class, new StringReader(content));
            OpenApiDocument.INSTANCE.modelFromStaticFile(document);
        }
        if (!this.openApiConfig.scanDisable()) {
            this.processAnnotations();
        } else {
            LOGGER.log(System.Logger.Level.TRACE, "OpenAPI Annotation processing is disabled");
        }
        OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)this.openApiConfig, (ClassLoader)contextClassLoader));
        OpenApiDocument.INSTANCE.initialize();
        OpenAPIImpl instance = (OpenAPIImpl)OpenApiDocument.INSTANCE.get();
        return MergeUtil.merge((OpenAPI)new OpenAPIImpl(), (OpenAPI)instance).openapi(instance.getOpenapi());
    }

    public String format(OpenAPI model, OpenApiFormat format) {
        StringWriter sw = new StringWriter();
        OpenApiSerializer.serialize(OpenApiHelper.types(), model, format, sw);
        return sw.toString();
    }

    List<FilteredIndexView> filteredIndexViews() {
        return (List)this.filteredIndexViews.get();
    }

    private void processAnnotations() {
        List<FilteredIndexView> indexViews = this.filteredIndexViews();
        if (this.openApiConfig.scanDisable() || indexViews.isEmpty()) {
            return;
        }
        OpenAPIImpl model = new OpenAPIImpl();
        for (IndexView indexView : indexViews) {
            OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(this.openApiConfig, indexView, this.scannerExtensions);
            OpenAPI scanned = scanner.scan(new String[0]);
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("Intermediate scanned from filtered index view %s:%n%s", indexView.getKnownClasses(), this.format(scanned, OpenApiFormat.YAML)));
            }
            model = MergeUtil.merge((OpenAPI)model, (OpenAPI)scanned).openapi(scanned.getOpenapi());
        }
        OpenApiDocument.INSTANCE.modelFromAnnotations((OpenAPI)model);
    }

    private List<FilteredIndexView> buildFilteredIndexViews() {
        BeanManager beanManager = CDI.current().getBeanManager();
        List jaxRsApps = ((JaxRsCdiExtension)beanManager.getExtension(JaxRsCdiExtension.class)).applicationsToRun();
        Set<Class<?>> annotatedTypes = ((OpenApiCdiExtension)beanManager.getExtension(OpenApiCdiExtension.class)).annotatedTypes();
        return new FilteredIndexViewsBuilder(this.config, jaxRsApps, annotatedTypes, this.managerConfig.indexPaths(), this.managerConfig.useJaxRsSemantics()).buildViews();
    }
}

