/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class WrappingPublisher
implements Publisher<Object> {
    private final Publisher<?> source;

    WrappingPublisher(Publisher<?> source) {
        this.source = source;
    }

    public void subscribe(Subscriber<? super Object> s) {
        this.source.subscribe((Subscriber)new WrappingSubscriber(s));
    }

    private static class WrappingSubscriber
    implements Subscriber<Object> {
        private final Subscriber<Object> sourceSubscriber;

        WrappingSubscriber(Subscriber<Object> sourceSubscriber) {
            this.sourceSubscriber = sourceSubscriber;
        }

        public void onSubscribe(Subscription s) {
            this.sourceSubscriber.onSubscribe(s);
        }

        public void onNext(Object t) {
            if (t instanceof Message) {
                this.sourceSubscriber.onNext(t);
                return;
            }
            this.sourceSubscriber.onNext((Object)Message.of((Object)t));
        }

        public void onError(Throwable t) {
            this.sourceSubscriber.onError(t);
        }

        public void onComplete() {
            this.sourceSubscriber.onComplete();
        }
    }
}

