/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.microprofile.messaging.MessageUtils;
import java.lang.reflect.Method;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class UnwrapProcessor
implements Processor<Object, Object> {
    private Method method;
    private Subscriber<? super Object> subscriber;

    UnwrapProcessor() {
    }

    static UnwrapProcessor of(Method method, Subscriber<? super Object> subscriber) {
        UnwrapProcessor unwrapProcessor = new UnwrapProcessor();
        unwrapProcessor.subscribe(subscriber);
        unwrapProcessor.setMethod(method);
        return unwrapProcessor;
    }

    Object unwrap(Object o) {
        return MessageUtils.unwrap(o, this.method);
    }

    public void subscribe(Subscriber<? super Object> subscriber) {
        this.subscriber = subscriber;
    }

    public void onSubscribe(Subscription s) {
        this.subscriber.onSubscribe(s);
    }

    public void onNext(Object o) {
        this.subscriber.onNext(this.unwrap(o));
    }

    public void onError(Throwable t) {
        this.subscriber.onError(t);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    void setMethod(Method method) {
        this.method = method;
    }
}

