/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.microprofile.messaging.ChannelHealthProbe;
import io.helidon.microprofile.messaging.ChannelRouter;
import io.helidon.microprofile.messaging.ExceptionUtils;
import io.helidon.microprofile.messaging.IncomingConnector;
import io.helidon.microprofile.messaging.IncomingMethod;
import io.helidon.microprofile.messaging.OutgoingConnector;
import io.helidon.microprofile.messaging.OutgoingMethod;
import io.helidon.microprofile.messaging.ProcessorMethod;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class UniversalChannel {
    private static final Logger LOGGER = Logger.getLogger(UniversalChannel.class.getName());
    private String name;
    private IncomingConnector incomingConnector;
    private ProcessorMethod incomingProcessorMethod;
    private IncomingMethod incomingMethod;
    private OutgoingMethod outgoingMethod;
    private OutgoingConnector outgoingConnector;
    private ProcessorMethod outgoingProcessorMethod;
    private final Config config;
    private final ChannelRouter router;
    private UniversalChannel upstreamChannel;
    private final AtomicBoolean live = new AtomicBoolean(true);
    private final AtomicBoolean ready = new AtomicBoolean(false);

    UniversalChannel(ChannelRouter router) {
        this.router = router;
        this.config = router.getConfig();
    }

    void setIncoming(IncomingMethod incomingMethod) {
        this.name = incomingMethod.getIncomingChannelName();
        this.incomingMethod = incomingMethod;
    }

    void setIncoming(ProcessorMethod processorMethod) {
        this.name = processorMethod.getIncomingChannelName();
        this.incomingProcessorMethod = processorMethod;
        this.incomingProcessorMethod.setOutgoingChannel(this);
    }

    void setOutgoing(ProcessorMethod processorMethod) {
        this.name = processorMethod.getOutgoingChannelName();
        this.outgoingProcessorMethod = processorMethod;
    }

    void setOutgoing(OutgoingMethod outgoingMethod) {
        this.name = outgoingMethod.getOutgoingChannelName();
        this.outgoingMethod = outgoingMethod;
    }

    AtomicBoolean isLive() {
        return this.live;
    }

    AtomicBoolean isReady() {
        return this.ready;
    }

    void connect() {
        Publisher<?> publisher;
        StringBuilder connectMessage = new StringBuilder("Connecting channel ").append(this.name).append(" with outgoing method ");
        if (this.outgoingMethod != null) {
            publisher = this.outgoingMethod.getPublisher();
            connectMessage.append(this.outgoingMethod.getMethod().getName());
        } else if (this.outgoingProcessorMethod != null) {
            publisher = this.outgoingProcessorMethod.getProcessor();
            this.upstreamChannel = this.outgoingProcessorMethod.getOutgoingChannel();
            connectMessage.append(this.outgoingProcessorMethod.getMethod().getName());
        } else if (this.outgoingConnector != null) {
            publisher = this.outgoingConnector.getPublisher(this.name);
            connectMessage.append(this.outgoingConnector.getConnectorName());
        } else {
            LOGGER.severe(connectMessage.append("and no outgoing method found!").toString());
            throw ExceptionUtils.createNoOutgoingMethodForChannel(this.name);
        }
        connectMessage.append(" and incoming method ");
        Optional<UniversalChannel> optUpstreamChannel = Optional.ofNullable(this.upstreamChannel);
        if (this.incomingMethod != null) {
            Subscriber<? super Object> subscriber1 = this.incomingMethod.getSubscriber();
            connectMessage.append(this.incomingMethod.getMethod().getName());
            ChannelHealthProbe.connect(publisher, subscriber1, this.live, this.ready);
            optUpstreamChannel.ifPresent(UniversalChannel::connect);
        } else if (this.incomingProcessorMethod != null) {
            Processor<Object, Object> subscriber1 = this.incomingProcessorMethod.getProcessor();
            connectMessage.append(this.incomingProcessorMethod.getMethod().getName());
            ChannelHealthProbe.connect(publisher, subscriber1, this.live, this.ready);
            optUpstreamChannel.ifPresent(UniversalChannel::connect);
        } else if (this.incomingConnector != null) {
            Subscriber<? super Object> subscriber1 = this.incomingConnector.getSubscriber(this.name);
            connectMessage.append(this.incomingConnector.getConnectorName());
            ChannelHealthProbe.connect(publisher, subscriber1, this.live, this.ready);
            optUpstreamChannel.ifPresent(UniversalChannel::connect);
        } else {
            LOGGER.severe(connectMessage.append("and no incoming method found!").toString());
            throw ExceptionUtils.createNoIncomingMethodForChannel(this.name);
        }
    }

    boolean isLastInChain() {
        return this.incomingProcessorMethod == null;
    }

    void findConnectors() {
        ConfigValue incomingConnectorName = this.config.get("mp.messaging.outgoing").get(this.name).get("connector").asString();
        ConfigValue outgoingConnectorName = this.config.get("mp.messaging.incoming").get(this.name).get("connector").asString();
        if (incomingConnectorName.isPresent()) {
            this.incomingConnector = this.router.getIncomingConnector((String)incomingConnectorName.get()).orElseThrow(() -> ExceptionUtils.createNoConnectorFound((String)incomingConnectorName.get()));
        }
        if (outgoingConnectorName.isPresent()) {
            this.outgoingConnector = this.router.getOutgoingConnector((String)outgoingConnectorName.get()).orElseThrow(() -> ExceptionUtils.createNoConnectorFound((String)outgoingConnectorName.get()));
        }
    }
}

