/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.microprofile.messaging.IncomingMethod;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ProxySubscriber<T>
implements Subscriber<T> {
    private final IncomingMethod method;
    private final Subscriber<T> originalSubscriber;

    ProxySubscriber(IncomingMethod method, Subscriber<T> originalSubscriber) {
        this.method = method;
        this.originalSubscriber = originalSubscriber;
    }

    public void onSubscribe(Subscription s) {
        this.originalSubscriber.onSubscribe(s);
    }

    public void onNext(T o) {
        this.originalSubscriber.onNext(this.preProcess(o));
        this.postProcess(o);
    }

    public void onError(Throwable t) {
        this.originalSubscriber.onError(t);
    }

    public void onComplete() {
        this.originalSubscriber.onComplete();
    }

    private T preProcess(T incomingValue) {
        if (this.method.getAckStrategy().equals((Object)Acknowledgment.Strategy.PRE_PROCESSING) && incomingValue instanceof Message) {
            Message incomingMessage = (Message)incomingValue;
            incomingMessage.ack();
        }
        return incomingValue;
    }

    private void postProcess(T incomingValue) {
        if (this.method.getAckStrategy().equals((Object)Acknowledgment.Strategy.POST_PROCESSING) && incomingValue instanceof Message) {
            Message incomingMessage = (Message)incomingValue;
            incomingMessage.ack();
        }
    }
}

