/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.microprofile.messaging.AbstractMessagingMethod;
import io.helidon.microprofile.messaging.InternalProcessor;
import io.helidon.microprofile.messaging.ProxyProcessor;
import io.helidon.microprofile.messaging.UniversalChannel;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanManager;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.reactivestreams.Processor;

class ProcessorMethod
extends AbstractMessagingMethod {
    private Processor<Object, Object> processor;
    private UniversalChannel outgoingChannel;

    ProcessorMethod(AnnotatedMethod<?> method, Errors.Collector errors) {
        super(method.getJavaMember(), errors);
        super.setIncomingChannelName(((Incoming)method.getAnnotation(Incoming.class)).value());
        super.setOutgoingChannelName(((Outgoing)method.getAnnotation(Outgoing.class)).value());
    }

    @Override
    public void init(BeanManager beanManager, Config config) {
        super.init(beanManager, config);
        this.processor = this.getType().isInvokeAtAssembly() ? new ProxyProcessor(this) : new InternalProcessor(this);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getIncomingChannelName() == null || this.getIncomingChannelName().trim().isEmpty()) {
            super.errors().fatal(String.format("Missing channel name in annotation @Incoming on method %s", this.getMethod()));
        }
        if (this.getOutgoingChannelName() == null || this.getOutgoingChannelName().trim().isEmpty()) {
            super.errors().fatal(String.format("Missing channel name in annotation @Outgoing on method %s", this.getMethod()));
        }
        if (this.getMethod().getParameterTypes().length > 1) {
            super.errors().fatal(String.format("Bad processor method signature, wrong number of parameters, only one or none allowed.%s", this.getMethod()));
        }
    }

    Processor<Object, Object> getProcessor() {
        return this.processor;
    }

    UniversalChannel getOutgoingChannel() {
        return this.outgoingChannel;
    }

    void setOutgoingChannel(UniversalChannel outgoingChannel) {
        this.outgoingChannel = outgoingChannel;
    }
}

