/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.microprofile.messaging.AbstractMessagingMethod;
import io.helidon.microprofile.messaging.InternalPublisher;
import io.helidon.microprofile.messaging.WrappingPublisher;
import java.lang.reflect.InvocationTargetException;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;

class OutgoingMethod
extends AbstractMessagingMethod {
    private Publisher<?> publisher;

    OutgoingMethod(AnnotatedMethod<?> method, Errors.Collector errors) {
        super(method.getJavaMember(), errors);
        super.setOutgoingChannelName(((Outgoing)method.getAnnotation(Outgoing.class)).value());
    }

    @Override
    public void init(BeanManager beanManager, Config config) {
        super.init(beanManager, config);
        if (this.getType().isInvokeAtAssembly()) {
            try {
                switch (this.getType()) {
                    case OUTGOING_PUBLISHER_MSG_2_VOID: {
                        this.publisher = (Publisher)this.getMethod().invoke(this.getBeanInstance(), new Object[0]);
                        break;
                    }
                    case OUTGOING_PUBLISHER_PAYL_2_VOID: {
                        this.publisher = new WrappingPublisher((Publisher)this.getMethod().invoke(this.getBeanInstance(), new Object[0]));
                        break;
                    }
                    case OUTGOING_PUBLISHER_BUILDER_MSG_2_VOID: {
                        this.publisher = ((PublisherBuilder)this.getMethod().invoke(this.getBeanInstance(), new Object[0])).buildRs();
                        break;
                    }
                    case OUTGOING_PUBLISHER_BUILDER_PAYL_2_VOID: {
                        this.publisher = new WrappingPublisher(((PublisherBuilder)this.getMethod().invoke(this.getBeanInstance(), new Object[0])).buildRs());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Not implemented signature %s", new Object[]{this.getType()}));
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DeploymentException((Throwable)e);
            }
        } else {
            this.publisher = new InternalPublisher(this.getMethod(), this.getBeanInstance());
        }
    }

    @Override
    void validate() {
        super.validate();
        if (this.getOutgoingChannelName() == null || this.getOutgoingChannelName().trim().isEmpty()) {
            super.errors().fatal(String.format("Missing channel name in annotation @Outgoing, method: %s", this.getMethod()));
        }
        if (this.getMethod().getReturnType().equals(Void.TYPE)) {
            super.errors().fatal(String.format("Method annotated as @Outgoing channel cannot have return type void, method: %s", this.getMethod()));
        }
    }

    Publisher<?> getPublisher() {
        return this.publisher;
    }
}

