/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.config.Config;
import io.helidon.microprofile.messaging.ChannelRouter;
import io.helidon.microprofile.messaging.PublishingConnector;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class OutgoingConnector
implements PublishingConnector {
    private final Config config;
    private final String connectorName;
    private final IncomingConnectorFactory connectorFactory;
    private final Map<String, Publisher<?>> publisherMap = new HashMap();

    OutgoingConnector(String connectorName, IncomingConnectorFactory connectorFactory, ChannelRouter router) {
        this.connectorName = connectorName;
        this.connectorFactory = connectorFactory;
        this.config = router.getConfig();
    }

    @Override
    public String getConnectorName() {
        return this.connectorName;
    }

    @Override
    public Config getRootConfig() {
        return this.config;
    }

    @Override
    public Publisher<?> getPublisher(String channelName) {
        Publisher publisher = this.publisherMap.computeIfAbsent(channelName, cn -> this.connectorFactory.getPublisherBuilder(this.getConnectorConfig(channelName)).buildRs());
        return publisher;
    }

    @Override
    public void subscribe(String channelName, Subscriber<? super Object> subscriber) {
        this.getPublisher(channelName).subscribe(subscriber);
    }
}

