/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.microprofile.messaging.MethodSignatureType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class MethodSignatureResolver {
    private final Class<?> returnType;
    private final Type genericReturnType;
    private final Class<?>[] parameterTypes;
    private final Type[] genericParameterTypes;
    private final List<Supplier<Optional<MethodSignatureType>>> resolveRules = new ArrayList<Supplier<Optional<MethodSignatureType>>>();
    private final Method method;

    private MethodSignatureResolver(Method method) {
        this.method = method;
        this.returnType = method.getReturnType();
        this.genericReturnType = method.getGenericReturnType();
        this.parameterTypes = method.getParameterTypes();
        this.genericParameterTypes = method.getGenericParameterTypes();
        this.addRule(MethodSignatureType.INCOMING_COMPLETION_STAGE_2_MSG, () -> this.returnsClassWithGenericParams(CompletionStage.class, MsgType.PAYLOAD) && this.hasFirstParam(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.INCOMING_COMPLETION_STAGE_2_PAYL, () -> this.returnsClassWithGenericParams(CompletionStage.class, MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD) && this.isIncoming());
        this.addRule(MethodSignatureType.INCOMING_SUBSCRIBER_BUILDER_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(SubscriberBuilder.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.INCOMING_SUBSCRIBER_BUILDER_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(SubscriberBuilder.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.INCOMING_SUBSCRIBER_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Subscriber.class, MsgType.MESSAGE) && this.isIncoming());
        this.addRule(MethodSignatureType.INCOMING_SUBSCRIBER_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Subscriber.class, MsgType.PAYLOAD) && this.isIncoming());
        this.addRule(MethodSignatureType.INCOMING_VOID_2_PAYL, () -> this.returnsVoid() && this.hasFirstParam(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_COMPL_STAGE_MSG_2_MSG, () -> this.returnsClassWithGenericParams(CompletionStage.class, MsgType.MESSAGE) && this.hasFirstParam(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_COMPL_STAGE_PAYL_2_PAYL, () -> this.returnsClassWithGenericParams(CompletionStage.class, MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PROCESSOR_BUILDER_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(ProcessorBuilder.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PROCESSOR_BUILDER_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(ProcessorBuilder.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PROCESSOR_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Processor.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PROCESSOR_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Processor.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_BUILDER_MSG_2_PUBLISHER_BUILDER_MSG, () -> this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.MESSAGE) && this.hasFirstParamClassWithGeneric(PublisherBuilder.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_BUILDER_PAYL_2_PUBLISHER_BUILDER_PAYL, () -> this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.PAYLOAD) && this.hasFirstParamClassWithGeneric(PublisherBuilder.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_BUILDER_MSG_2_MSG, () -> this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.MESSAGE) && this.hasFirstParam(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_BUILDER_PAYL_2_PAYL, () -> this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_MSG_2_PUBLISHER_MSG, () -> this.returnsClassWithGenericParams(Publisher.class, MsgType.MESSAGE) && this.hasFirstParamClassWithGeneric(Publisher.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_PAYL_2_PUBLISHER_PAYL, () -> this.returnsClassWithGenericParams(Publisher.class, MsgType.PAYLOAD) && this.hasFirstParamClassWithGeneric(Publisher.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_MSG_2_MSG, () -> this.returnsClassWithGenericParams(Publisher.class, MsgType.MESSAGE) && this.hasFirstParam(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PUBLISHER_PAYL_2_PAYL, () -> this.returnsClassWithGenericParams(Publisher.class, MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.PROCESSOR_MSG_2_MSG, () -> this.returns(MsgType.MESSAGE) && this.hasFirstParam(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.PROCESSOR_PAYL_2_PAYL, () -> this.returns(MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.OUTGOING_COMPLETION_STAGE_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(CompletionStage.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.OUTGOING_COMPLETION_STAGE_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(CompletionStage.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.OUTGOING_PUBLISHER_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Publisher.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.OUTGOING_PUBLISHER_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(Publisher.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.OUTGOING_PUBLISHER_BUILDER_MSG_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.MESSAGE));
        this.addRule(MethodSignatureType.OUTGOING_PUBLISHER_BUILDER_PAYL_2_VOID, () -> this.hasNoParams() && this.returnsClassWithGenericParams(PublisherBuilder.class, MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.OUTGOING_MSG_2_VOID, () -> this.hasNoParams() && this.returns(MsgType.MESSAGE));
        this.addRule(MethodSignatureType.OUTGOING_PAYL_2_VOID, () -> this.hasNoParams() && this.returns(MsgType.PAYLOAD));
        this.addRule(MethodSignatureType.INCOMING_VOID_2_PAYL, () -> this.returns(MsgType.PAYLOAD) && this.hasFirstParam(MsgType.PAYLOAD));
    }

    Optional<MethodSignatureType> resolve() {
        return this.resolveRules.stream().map(Supplier::get).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    static MethodSignatureResolver create(Method method) {
        return new MethodSignatureResolver(method);
    }

    private void addRule(MethodSignatureType type, Supplier<Boolean> predicate) {
        this.resolveRules.add(() -> Optional.of(type).filter(arg_0 -> MethodSignatureResolver.lambda$addRule$32((Supplier)predicate, arg_0)));
    }

    private boolean hasNoParams() {
        return this.method.getParameterCount() == 0;
    }

    private boolean returnsVoid() {
        return Void.TYPE.equals(this.returnType);
    }

    private boolean returns(MsgType msgType) {
        if (this.returnsVoid()) {
            return false;
        }
        return msgType == MsgType.MESSAGE && Message.class.isAssignableFrom(this.returnType) || msgType == MsgType.PAYLOAD && !Message.class.isAssignableFrom(this.returnType);
    }

    private boolean hasFirstParam(MsgType msgType) {
        if (this.hasNoParams()) {
            return false;
        }
        Class<?> firstParam = this.parameterTypes[0];
        return msgType == MsgType.MESSAGE && Message.class.isAssignableFrom(firstParam) || msgType == MsgType.PAYLOAD && !Message.class.equals(firstParam);
    }

    private boolean hasFirstParamClassWithGeneric(Class<?> clazz, MsgType msgType) {
        if (this.hasNoParams()) {
            return false;
        }
        if (!clazz.isAssignableFrom(this.parameterTypes[0])) {
            return false;
        }
        Type firstParam = this.genericParameterTypes[0];
        if (!(firstParam instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramReturnType = (ParameterizedType)firstParam;
        Type[] actualTypeArguments = paramReturnType.getActualTypeArguments();
        if (msgType == MsgType.MESSAGE) {
            if (!(actualTypeArguments[0] instanceof ParameterizedType)) {
                return false;
            }
            return Message.class.equals((Object)((ParameterizedType)actualTypeArguments[0]).getRawType());
        }
        return !Message.class.equals((Object)firstParam);
    }

    private boolean returnsClassWithGenericParams(Class<?> clazz, MsgType msgType) {
        if (this.returnsVoid()) {
            return false;
        }
        if (!clazz.isAssignableFrom(this.returnType)) {
            return false;
        }
        if (!(this.genericReturnType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramReturnType = (ParameterizedType)this.genericReturnType;
        Type[] actualTypeArguments = paramReturnType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return false;
        }
        if (msgType == MsgType.MESSAGE) {
            if (!(actualTypeArguments[0] instanceof ParameterizedType)) {
                return false;
            }
            return Message.class.equals((Object)((ParameterizedType)actualTypeArguments[0]).getRawType());
        }
        if (msgType == MsgType.WILDCARD) {
            return actualTypeArguments[0] instanceof WildcardType;
        }
        if (actualTypeArguments[0] instanceof ParameterizedType && Message.class.equals((Object)((ParameterizedType)actualTypeArguments[0]).getRawType())) {
            return false;
        }
        return !Message.class.equals((Object)actualTypeArguments[0]);
    }

    private boolean isIncoming() {
        return this.hasAnnotation(Incoming.class) && !this.hasAnnotation(Outgoing.class);
    }

    private boolean isOutgoing() {
        return !this.hasAnnotation(Incoming.class) && this.hasAnnotation(Outgoing.class);
    }

    private boolean isProcessor() {
        return this.hasAnnotation(Incoming.class) && this.hasAnnotation(Outgoing.class);
    }

    private <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        T annotation = this.method.getAnnotation(clazz);
        return Objects.nonNull(annotation);
    }

    private static /* synthetic */ boolean lambda$addRule$32(Supplier predicate, MethodSignatureType t) {
        return (Boolean)predicate.get();
    }

    private static enum MsgType {
        MESSAGE,
        PAYLOAD,
        WILDCARD;

    }
}

