/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.microprofile.messaging.ChannelRouter;
import io.helidon.microprofile.messaging.UniversalChannel;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;

public class MessagingCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(MessagingCdiExtension.class.getName());
    private final ChannelRouter channelRouter = new ChannelRouter();

    public Map<String, Boolean> channelsLiveness() {
        return this.channelRouter.getChannelMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UniversalChannel)e.getValue()).isLive().get()));
    }

    public Map<String, Boolean> channelsReadiness() {
        return this.channelRouter.getChannelMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UniversalChannel)e.getValue()).isReady().get()));
    }

    private void registerChannelMethods(@Observes @WithAnnotations(value={Incoming.class, Outgoing.class}) ProcessAnnotatedType<?> pat) {
        pat.getAnnotatedType().getMethods().forEach(this.channelRouter::registerMethod);
    }

    private void onProcessBean(@Observes ProcessManagedBean<?> event) {
        if (null != event.getAnnotatedBeanClass().getAnnotation(Connector.class)) {
            this.channelRouter.registerConnectorFactory(event.getBean());
        }
        this.channelRouter.registerBeanReference(event.getBean());
    }

    private void deploymentValidation(@Observes AfterDeploymentValidation event) {
        Errors.Collector errors = this.channelRouter.getErrors();
        boolean hasFatal = errors.hasFatal();
        Errors errorMessages = errors.collect();
        if (hasFatal) {
            throw new DeploymentException(errorMessages.toString());
        }
        errorMessages.log(LOGGER);
    }

    private void makeConnections(@Observes @Priority(value=4101) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.channelRouter.connect(beanManager);
    }
}

