/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class MessageUtils {
    private MessageUtils() {
    }

    static Object wrap(Object o) {
        if (o instanceof Message) {
            return o;
        }
        return Message.of((Object)o);
    }

    static Object unwrap(Object o) {
        if (o instanceof Message) {
            return ((Message)o).getPayload();
        }
        return o;
    }

    static Object unwrap(Object value, Class<?> type) {
        return MessageUtils.unwrap(value, type, () -> CompletableFuture.completedFuture(null));
    }

    static Object unwrap(Object value, Class<?> type, Supplier<CompletionStage<Void>> onAck) {
        if (Message.class.isAssignableFrom(type)) {
            if (value instanceof Message) {
                return value;
            }
            return Message.of((Object)value, onAck);
        }
        if (value instanceof Message) {
            return ((Message)value).getPayload();
        }
        return value;
    }

    static Object unwrap(Object value, Method method) {
        if (MessageUtils.isMessageType(method)) {
            return MessageUtils.unwrap(value, Message.class);
        }
        return MessageUtils.unwrap(value, MessageUtils.getFirstGenericType(method));
    }

    static boolean isMessageType(Method method) {
        Type returnType = method.getGenericReturnType();
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (SubscriberBuilder.class.equals(method.getReturnType())) {
            if (actualTypeArguments.length != 2) {
                throw new DeploymentException("Invalid method return type " + method);
            }
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        if (Subscriber.class.equals(method.getReturnType())) {
            if (actualTypeArguments.length != 1) {
                throw new DeploymentException("Invalid method return type " + method);
            }
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        if (Processor.class.equals(method.getReturnType())) {
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        if (ProcessorBuilder.class.equals(method.getReturnType())) {
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        if (PublisherBuilder.class.equals(method.getReturnType())) {
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        if (Publisher.class.equals(method.getReturnType())) {
            return MessageUtils.isMessageType(actualTypeArguments[0]);
        }
        throw new InvalidParameterException("Unsupported method for unwrapping " + method);
    }

    private static boolean isMessageType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return Message.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    private static Class<?> getFirstGenericType(Method method) {
        Type returnType = method.getGenericReturnType();
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Type type = actualTypeArguments[0];
        if (type instanceof ParameterizedType) {
            ParameterizedType firstParameterizedType = (ParameterizedType)type;
            return (Class)firstParameterizedType.getRawType();
        }
        return (Class)type;
    }
}

