/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.reactive.RequestedCounter;
import io.helidon.microprofile.messaging.CompletableQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class InternalPublisher
implements Publisher<Object>,
Subscription {
    private Subscriber<? super Object> subscriber;
    private final Method method;
    private final Object beanInstance;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final CompletableQueue<Object> completableQueue;
    private final RequestedCounter requestedCounter = new RequestedCounter();

    InternalPublisher(Method method, Object beanInstance) {
        this.method = method;
        this.beanInstance = beanInstance;
        this.completableQueue = CompletableQueue.create((o, throwable) -> {
            if (Objects.isNull(throwable)) {
                this.subscriber.onNext(o.getValue());
                this.trySubmit();
            } else {
                this.subscriber.onError(throwable);
            }
        });
    }

    public void subscribe(Subscriber<? super Object> s) {
        this.subscriber = s;
        this.subscriber.onSubscribe((Subscription)this);
    }

    public void request(long n) {
        this.requestedCounter.increment(n, arg_0 -> this.subscriber.onError(arg_0));
        this.trySubmit();
    }

    private void trySubmit() {
        try {
            while (!this.completableQueue.isBackPressureLimitReached() && this.requestedCounter.tryDecrement() && !this.closed.get()) {
                Object result = this.method.invoke(this.beanInstance, new Object[0]);
                if (result instanceof CompletionStage) {
                    CompletionStage completionStage = (CompletionStage)result;
                    this.completableQueue.add(completionStage.toCompletableFuture());
                    continue;
                }
                this.subscriber.onNext(result);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.subscriber.onError((Throwable)e);
        }
    }

    public void cancel() {
        this.closed.set(true);
    }
}

