/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.microprofile.messaging.AbstractMessagingMethod;
import io.helidon.microprofile.messaging.InternalSubscriber;
import io.helidon.microprofile.messaging.ProxySubscriber;
import io.helidon.microprofile.messaging.UnwrapProcessor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanManager;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Subscriber;

class IncomingMethod
extends AbstractMessagingMethod {
    private Subscriber<? super Object> subscriber;

    IncomingMethod(AnnotatedMethod<?> method, Errors.Collector errors) {
        super(method.getJavaMember(), errors);
        super.setIncomingChannelName(((Incoming)method.getAnnotation(Incoming.class)).value());
    }

    @Override
    void validate() {
        super.validate();
        if (this.getIncomingChannelName() == null || this.getIncomingChannelName().trim().isEmpty()) {
            super.errors().fatal(String.format("Missing channel name in annotation @Incoming on method %s", this.getMethod().toString()));
        }
    }

    @Override
    public void init(BeanManager beanManager, Config config) {
        block5: {
            block4: {
                super.init(beanManager, config);
                if (!this.getType().isInvokeAtAssembly()) break block4;
                switch (this.getType()) {
                    case INCOMING_SUBSCRIBER_MSG_2_VOID: 
                    case INCOMING_SUBSCRIBER_PAYL_2_VOID: {
                        Subscriber originalPaylSubscriber = (Subscriber)this.invoke(new Object[0]);
                        UnwrapProcessor unwrappedSubscriber = UnwrapProcessor.of(this.getMethod(), (Subscriber<? super Object>)originalPaylSubscriber);
                        this.subscriber = new ProxySubscriber<Object>(this, (Subscriber<? super Object>)unwrappedSubscriber);
                        break block5;
                    }
                    case INCOMING_SUBSCRIBER_BUILDER_MSG_2_VOID: 
                    case INCOMING_SUBSCRIBER_BUILDER_PAYL_2_VOID: {
                        SubscriberBuilder originalSubscriberBuilder = (SubscriberBuilder)this.invoke(new Object[0]);
                        UnwrapProcessor unwrappedBuilder = UnwrapProcessor.of(this.getMethod(), (Subscriber<? super Object>)originalSubscriberBuilder.build());
                        this.subscriber = new ProxySubscriber<Object>(this, (Subscriber<? super Object>)unwrappedBuilder);
                        break block5;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Not implemented signature %s", new Object[]{this.getType()}));
                    }
                }
            }
            this.subscriber = new InternalSubscriber(this);
        }
    }

    Subscriber<? super Object> getSubscriber() {
        return this.subscriber;
    }
}

