/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.config.Config;
import io.helidon.microprofile.messaging.ChannelRouter;
import io.helidon.microprofile.messaging.SubscribingConnector;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.reactivestreams.Subscriber;

class IncomingConnector
implements SubscribingConnector {
    private final Config config;
    private final String connectorName;
    private final OutgoingConnectorFactory connectorFactory;
    private final Map<String, Subscriber<? super Object>> subscriberMap = new HashMap<String, Subscriber<? super Object>>();

    IncomingConnector(String connectorName, OutgoingConnectorFactory connectorFactory, ChannelRouter router) {
        this.connectorName = connectorName;
        this.connectorFactory = connectorFactory;
        this.config = router.getConfig();
    }

    @Override
    public Subscriber<? super Object> getSubscriber(String channelName) {
        Subscriber subscriber = this.subscriberMap.computeIfAbsent(channelName, cn -> this.connectorFactory.getSubscriberBuilder(this.getConnectorConfig(channelName)).build());
        return subscriber;
    }

    @Override
    public String getConnectorName() {
        return this.connectorName;
    }

    @Override
    public Config getRootConfig() {
        return this.config;
    }
}

