/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.microprofile.messaging.MessagingDeploymentException;
import io.helidon.microprofile.messaging.MessagingException;

final class ExceptionUtils {
    private ExceptionUtils() {
    }

    static MessagingDeploymentException createNoConnectorFound(String connectorName) {
        return new MessagingDeploymentException(String.format("No connector %s found!", connectorName));
    }

    static MessagingDeploymentException createNoIncomingMethodForChannel(String channelName) {
        return new MessagingDeploymentException(String.format("No incoming method or connector for channel %s found!", channelName));
    }

    static MessagingDeploymentException createNoOutgoingMethodForChannel(String channelName) {
        return new MessagingDeploymentException(String.format("No outgoing method or connector for channel %s found!", channelName));
    }

    static MessagingException createCompletableQueueOverflow(long maxSize) {
        return new MessagingException(String.format("Maximum size %d of queue overflow!", maxSize));
    }
}

