/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.microprofile.messaging.AdHocConfigBuilder;
import javax.enterprise.inject.spi.DeploymentException;

interface ConfigurableConnector {
    public String getConnectorName();

    public Config getRootConfig();

    public Config getChannelsConfig();

    default public org.eclipse.microprofile.config.Config getConnectorConfig(String channelName) {
        Config channelConfig = this.getChannelsConfig().get(channelName);
        ConfigValue connectorName = channelConfig.get("connector").asString();
        if (!connectorName.isPresent()) {
            throw new DeploymentException(String.format("No connector configured for channel %s", channelName));
        }
        if (!((String)connectorName.get()).equals(this.getConnectorName())) {
            throw new DeploymentException(String.format("Connector name miss match for channel%s", channelName));
        }
        Config connectorConfig = this.getRootConfig().get("mp.messaging.connector").get((String)connectorName.get());
        return AdHocConfigBuilder.from(connectorConfig).put("channel-name", channelName).putAll(channelConfig).build();
    }
}

