/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.microprofile.messaging.ExceptionUtils;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;

class CompletableQueue<T> {
    private static final long MAX_QUEUE_SIZE = 2048L;
    private static final long BACK_PRESSURE_LIMIT = 1536L;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final LinkedList<Item<T>> queue = new LinkedList();
    private final AtomicLong size = new AtomicLong();
    private volatile BiConsumer<Item<T>, ? super Throwable> onEachComplete;

    private CompletableQueue(BiConsumer<Item<T>, ? super Throwable> onEachComplete) {
        this.onEachComplete = onEachComplete;
    }

    static <T> CompletableQueue<T> create(BiConsumer<Item<T>, ? super Throwable> onEachComplete) {
        return new CompletableQueue<T>(onEachComplete);
    }

    static <T> CompletableQueue<T> create() {
        return new CompletableQueue<T>(null);
    }

    void onEachComplete(BiConsumer<Item<T>, ? super Throwable> onEachComplete) {
        this.onEachComplete = onEachComplete;
        this.tryFlush();
    }

    boolean isBackPressureLimitReached() {
        return 1536L <= this.size.get();
    }

    void add(CompletableFuture<T> future, Object metadata) {
        try {
            this.queueLock.lock();
            this.queue.add(Item.create(future, metadata));
            if (this.size.incrementAndGet() > 2048L) {
                throw ExceptionUtils.createCompletableQueueOverflow(2048L);
            }
            future.whenComplete((t, u) -> this.tryFlush());
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void add(CompletableFuture<T> future) {
        this.add(future, null);
    }

    private void tryFlush() {
        block11: {
            try {
                BiConsumer<Item<Item<T>>, Throwable> onEachComplete;
                block10: {
                    this.queueLock.lock();
                    onEachComplete = this.onEachComplete;
                    try {
                        if (onEachComplete != null) break block10;
                        return;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        onEachComplete.accept(null, e);
                        break block11;
                    }
                }
                while (!this.queue.isEmpty() && this.queue.getFirst().getCompletableFuture().isDone()) {
                    Item<T> item = this.queue.poll();
                    if (Objects.isNull(item)) {
                        return;
                    }
                    this.size.decrementAndGet();
                    item.setValue(item.getCompletableFuture().get());
                    onEachComplete.accept(item, null);
                }
                return;
            }
            finally {
                this.queueLock.unlock();
            }
        }
    }

    static class Item<T> {
        private final CompletableFuture<T> completableFuture;
        private final Object metadata;
        private T value;

        private Item(CompletableFuture<T> completableFuture, Object metadata) {
            this.completableFuture = completableFuture;
            this.metadata = metadata;
        }

        static <T> Item<T> create(CompletableFuture<T> completableFuture) {
            return new Item<T>(completableFuture, null);
        }

        static <T> Item<T> create(CompletableFuture<T> completableFuture, Object metadata) {
            return new Item<T>(completableFuture, metadata);
        }

        CompletableFuture<T> getCompletableFuture() {
            return this.completableFuture;
        }

        Object getMetadata() {
            return this.metadata;
        }

        T getValue() {
            return this.value;
        }

        void setValue(T value) {
            this.value = value;
        }
    }
}

