/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.microprofile.messaging.AbstractMessagingMethod;
import io.helidon.microprofile.messaging.IncomingConnector;
import io.helidon.microprofile.messaging.IncomingMethod;
import io.helidon.microprofile.messaging.OutgoingConnector;
import io.helidon.microprofile.messaging.OutgoingMethod;
import io.helidon.microprofile.messaging.ProcessorMethod;
import io.helidon.microprofile.messaging.UniversalChannel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;

class ChannelRouter {
    private final Errors.Collector errors = Errors.collector();
    private final Config config = (Config)ConfigProvider.getConfig();
    private final List<AbstractMessagingMethod> connectableBeanMethods = new ArrayList<AbstractMessagingMethod>();
    private final Map<String, UniversalChannel> channelMap = new HashMap<String, UniversalChannel>();
    private final Map<String, IncomingConnector> incomingConnectorMap = new HashMap<String, IncomingConnector>();
    private final Map<String, OutgoingConnector> outgoingConnectorMap = new HashMap<String, OutgoingConnector>();
    private final List<Bean<?>> incomingConnectorFactoryList = new ArrayList();
    private final List<Bean<?>> outgoingConnectorFactoryList = new ArrayList();
    private BeanManager beanManager;

    ChannelRouter() {
    }

    void registerBeanReference(Bean<?> bean) {
        this.connectableBeanMethods.stream().filter(m -> m.getDeclaringType() == bean.getBeanClass()).forEach(m -> m.setDeclaringBean(bean));
    }

    Map<String, UniversalChannel> getChannelMap() {
        return this.channelMap;
    }

    void connect(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.incomingConnectorFactoryList.forEach(this::addOutgoingConnector);
        this.outgoingConnectorFactoryList.forEach(this::addIncomingConnector);
        this.connectableBeanMethods.forEach(m -> m.init(beanManager, this.config));
        this.channelMap.values().forEach(UniversalChannel::findConnectors);
        this.channelMap.values().stream().filter(UniversalChannel::isLastInChain).forEach(UniversalChannel::connect);
    }

    void registerMethod(AnnotatedMethod<?> m) {
        if (m.isAnnotationPresent(Incoming.class) && m.isAnnotationPresent(Outgoing.class)) {
            this.addProcessorMethod(m);
        } else if (m.isAnnotationPresent(Incoming.class)) {
            this.addIncomingMethod(m);
        } else if (m.isAnnotationPresent(Outgoing.class)) {
            this.addOutgoingMethod(m);
        }
    }

    void registerConnectorFactory(Bean<?> bean) {
        Class beanType = bean.getBeanClass();
        Connector annotation = beanType.getAnnotation(Connector.class);
        if (IncomingConnectorFactory.class.isAssignableFrom(beanType) && null != annotation) {
            this.incomingConnectorFactoryList.add(bean);
        }
        if (OutgoingConnectorFactory.class.isAssignableFrom(beanType) && null != annotation) {
            this.outgoingConnectorFactoryList.add(bean);
        }
    }

    Config getConfig() {
        return this.config;
    }

    Optional<IncomingConnector> getIncomingConnector(String connectorName) {
        return Optional.ofNullable(this.incomingConnectorMap.get(connectorName));
    }

    Optional<OutgoingConnector> getOutgoingConnector(String connectorName) {
        return Optional.ofNullable(this.outgoingConnectorMap.get(connectorName));
    }

    private void addIncomingConnector(Bean<?> bean) {
        OutgoingConnectorFactory outgoingConnectorFactory = (OutgoingConnectorFactory)ChannelRouter.lookup(bean, this.beanManager);
        String connectorName = bean.getBeanClass().getAnnotation(Connector.class).value();
        IncomingConnector incomingConnector = new IncomingConnector(connectorName, outgoingConnectorFactory, this);
        this.incomingConnectorMap.put(connectorName, incomingConnector);
    }

    private void addOutgoingConnector(Bean<?> bean) {
        IncomingConnectorFactory incomingConnectorFactory = (IncomingConnectorFactory)ChannelRouter.lookup(bean, this.beanManager);
        String connectorName = bean.getBeanClass().getAnnotation(Connector.class).value();
        OutgoingConnector outgoingConnector = new OutgoingConnector(connectorName, incomingConnectorFactory, this);
        this.outgoingConnectorMap.put(connectorName, outgoingConnector);
    }

    private void addIncomingMethod(AnnotatedMethod<?> m) {
        IncomingMethod incomingMethod = new IncomingMethod(m, this.errors);
        incomingMethod.validate();
        String channelName = incomingMethod.getIncomingChannelName();
        UniversalChannel universalChannel = this.getOrCreateChannel(channelName);
        universalChannel.setIncoming(incomingMethod);
        this.connectableBeanMethods.add(incomingMethod);
    }

    private void addOutgoingMethod(AnnotatedMethod<?> m) {
        OutgoingMethod outgoingMethod = new OutgoingMethod(m, this.errors);
        outgoingMethod.validate();
        String channelName = outgoingMethod.getOutgoingChannelName();
        UniversalChannel universalChannel = this.getOrCreateChannel(channelName);
        universalChannel.setOutgoing(outgoingMethod);
        this.connectableBeanMethods.add(outgoingMethod);
    }

    private void addProcessorMethod(AnnotatedMethod<?> m) {
        ProcessorMethod channelMethod = new ProcessorMethod(m, this.errors);
        channelMethod.validate();
        String incomingChannelName = channelMethod.getIncomingChannelName();
        String outgoingChannelName = channelMethod.getOutgoingChannelName();
        UniversalChannel incomingUniversalChannel = this.getOrCreateChannel(incomingChannelName);
        incomingUniversalChannel.setIncoming(channelMethod);
        UniversalChannel outgoingUniversalChannel = this.getOrCreateChannel(outgoingChannelName);
        outgoingUniversalChannel.setOutgoing(channelMethod);
        this.connectableBeanMethods.add(channelMethod);
    }

    private UniversalChannel getOrCreateChannel(String channelName) {
        UniversalChannel universalChannel = this.channelMap.get(channelName);
        if (universalChannel == null) {
            universalChannel = new UniversalChannel(this);
            this.channelMap.put(channelName, universalChannel);
        }
        return universalChannel;
    }

    static <T> T lookup(Bean<?> bean, BeanManager beanManager) {
        Context context = beanManager.getContext(bean.getScope());
        Object instance = context.get(bean);
        if (instance == null) {
            CreationalContext creationalContext = beanManager.createCreationalContext(bean);
            instance = beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
        }
        if (instance == null) {
            throw new DeploymentException("Instance of bean " + bean.getName() + " not found");
        }
        return (T)instance;
    }

    Errors.Collector getErrors() {
        return this.errors;
    }
}

